/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.ContextualRegistry;
import io.helidon.webserver.RequestRouting;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerBasicConfig;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.spi.WebServerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public interface WebServer {
    public ServerConfiguration configuration();

    public CompletionStage<WebServer> start();

    public CompletionStage<WebServer> whenShutdown();

    public CompletionStage<WebServer> shutdown();

    public boolean isRunning();

    public ContextualRegistry context();

    default public int port() {
        return this.port("@default");
    }

    public int port(String var1);

    public static WebServer create(io.helidon.common.Builder<? extends ServerConfiguration> configurationBuilder, Routing routing) {
        return WebServer.create(configurationBuilder != null ? (ServerConfiguration)configurationBuilder.build() : null, routing);
    }

    public static WebServer create(io.helidon.common.Builder<? extends ServerConfiguration> configurationBuilder, io.helidon.common.Builder<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configurationBuilder != null ? (ServerConfiguration)configurationBuilder.build() : null, (Routing)routingBuilder.build());
    }

    public static WebServer create(ServerConfiguration configuration, io.helidon.common.Builder<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create(configuration, (Routing)routingBuilder.build());
    }

    public static WebServer create(Routing routing) {
        return WebServer.create((ServerConfiguration)null, routing);
    }

    public static WebServer create(ServerConfiguration configuration, Routing routing) {
        Objects.requireNonNull(routing, "Parameter 'routing' is null!");
        return WebServer.builder(routing).configuration(configuration).build();
    }

    public static WebServer create(io.helidon.common.Builder<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.create((Routing)routingBuilder.build());
    }

    public static Builder builder(io.helidon.common.Builder<? extends Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return WebServer.builder((Routing)routingBuilder.build());
    }

    public static Builder builder(Routing routing) {
        return new Builder(routing);
    }

    public static final class Builder
    implements io.helidon.common.Builder<WebServer> {
        private final Map<String, Routing> routings = new HashMap<String, Routing>();
        private final Routing defaultRouting;
        private ServerConfiguration configuration;

        private Builder(Routing defaultRouting) {
            Objects.requireNonNull(defaultRouting, "Parameter 'default routing' must not be null!");
            this.defaultRouting = defaultRouting;
        }

        public Builder configuration(ServerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder configuration(io.helidon.common.Builder<ServerConfiguration> configurationBuilder) {
            this.configuration = configurationBuilder != null ? (ServerConfiguration)configurationBuilder.build() : null;
            return this;
        }

        public Builder addNamedRouting(String name, Routing routing) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routing, "Parameter 'routing' must not be null!");
            this.routings.put(name, routing);
            return this;
        }

        public Builder addNamedRouting(String name, io.helidon.common.Builder<Routing> routingBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
            return this.addNamedRouting(name, (Routing)routingBuilder.build());
        }

        public WebServer build() {
            String unpairedRoutings = this.routings.keySet().stream().filter(routingName -> this.configuration == null || this.configuration.socket((String)routingName) == null).collect(Collectors.joining(", "));
            if (!unpairedRoutings.isEmpty()) {
                throw new IllegalStateException("No server socket configuration found for named routings: " + unpairedRoutings);
            }
            WebServer result = this.loadFactory().newWebServer(this.configuration == null ? ServerBasicConfig.DEFAULT_CONFIGURATION : this.configuration, this.defaultRouting, this.routings);
            if (this.defaultRouting instanceof RequestRouting) {
                ((RequestRouting)this.defaultRouting).fireNewWebServer(result);
            }
            return result;
        }

        private WebServerFactory loadFactory() {
            Iterator<WebServerFactory> implementations = ServiceLoader.load(WebServerFactory.class).iterator();
            if (implementations.hasNext()) {
                return implementations.next();
            }
            throw new IllegalStateException("No implementation found for SPI: " + WebServerFactory.class.getName());
        }
    }
}

