/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.Route;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

class RouteList
extends ArrayList<Route>
implements Route {
    private static final long serialVersionUID = 1L;
    private final transient PathMatcher pathContext;
    private final transient Route.HttpMethodPredicate methodPredicate;

    RouteList(PathMatcher pathContext, Collection<Route> records) {
        super(records);
        boolean acceptSomeMethods = false;
        Set<Object> acceptedMethods = new HashSet<Http.RequestMethod>();
        for (Route record : records) {
            Set<Http.RequestMethod> mtds = record.acceptedMethods();
            if (mtds == null) continue;
            acceptSomeMethods = true;
            if (mtds.isEmpty()) {
                acceptedMethods = Collections.emptySet();
                break;
            }
            acceptedMethods.addAll(mtds);
        }
        this.methodPredicate = acceptSomeMethods ? new Route.HttpMethodPredicate(acceptedMethods) : null;
        this.pathContext = pathContext;
    }

    RouteList(Collection<Route> records) {
        this(null, records);
    }

    PathMatcher getPathContext() {
        return this.pathContext;
    }

    @Override
    public Set<Http.RequestMethod> acceptedMethods() {
        return this.methodPredicate == null ? null : this.methodPredicate.acceptedMethods();
    }

    @Override
    public boolean accepts(Http.RequestMethod method) {
        return this.methodPredicate != null && this.methodPredicate.test(method);
    }

    public PathMatcher.PrefixResult prefixMatch(CharSequence path) {
        return this.pathContext == null ? EMPTY_PATH_MATCHER.prefixMatch(path) : this.pathContext.prefixMatch(path);
    }

    @Override
    public void trimToSize() {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public Route set(int index, Route route) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean add(Route route) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public void add(int index, Route route) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public Route remove(int index) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public boolean removeIf(Predicate filter) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public void replaceAll(UnaryOperator operator) {
        throw new UnsupportedOperationException("An immutable instance!");
    }

    @Override
    public void sort(Comparator c) {
        throw new UnsupportedOperationException("An immutable instance!");
    }
}

