/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.Handler;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.Route;
import io.helidon.webserver.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class HandlerRoute
implements Route {
    private final PathMatcher pathMatcher;
    private final Handler handler;
    private final List<Service> serviceContext;
    private final Route.HttpMethodPredicate methodPredicate;
    private final Map<String, String> diagnosticEvent;

    HandlerRoute(List<Service> serviceContext, PathMatcher pathMatcher, Handler handler, Iterable<Http.RequestMethod> methods) {
        this.serviceContext = serviceContext == null || serviceContext.isEmpty() ? Collections.emptyList() : new ArrayList<Service>(serviceContext);
        if (methods == null) {
            this.methodPredicate = new Route.HttpMethodPredicate(null);
        } else if (methods instanceof Collection) {
            this.methodPredicate = new Route.HttpMethodPredicate((Collection)methods);
        } else {
            ArrayList<Http.RequestMethod> mtds = new ArrayList<Http.RequestMethod>();
            for (Http.RequestMethod method : methods) {
                mtds.add(method);
            }
            this.methodPredicate = new Route.HttpMethodPredicate(mtds);
        }
        this.pathMatcher = pathMatcher == null ? EMPTY_PATH_MATCHER : pathMatcher;
        this.handler = handler;
        HashMap<String, String> eventData = new HashMap<String, String>(5);
        eventData.put("event", "handler");
        if (this.handler != null) {
            eventData.put("handler.class", this.handler.getClass().getName());
        }
        if (!this.serviceContext.isEmpty()) {
            eventData.put("service.context.classes", this.serviceContext.stream().map(s -> s.getClass().getName()).collect(Collectors.joining(" ")));
        }
        this.diagnosticEvent = Collections.unmodifiableMap(eventData);
    }

    HandlerRoute(List<Service> serviceContext, PathMatcher pathMatcher, Handler handler, Http.RequestMethod ... methods) {
        this(serviceContext, pathMatcher, handler, Arrays.asList(methods));
    }

    HandlerRoute(List<Service> serviceContext, Handler handler, Http.RequestMethod ... methods) {
        this(serviceContext, EMPTY_PATH_MATCHER, handler, methods);
    }

    HandlerRoute(List<Service> serviceContext, Handler handler, Iterable<Http.RequestMethod> methods) {
        this(serviceContext, EMPTY_PATH_MATCHER, handler, methods);
    }

    @Override
    public Set<Http.RequestMethod> acceptedMethods() {
        return this.methodPredicate.acceptedMethods();
    }

    @Override
    public boolean accepts(Http.RequestMethod method) {
        return this.methodPredicate.test(method);
    }

    public Handler handler() {
        return this.handler;
    }

    public Map<String, String> diagnosticEvent() {
        return this.diagnosticEvent;
    }

    public PathMatcher.Result match(CharSequence path) {
        return this.pathMatcher.match(path);
    }

    public String toString() {
        return "HandlerRoute{pathMatcher=" + this.pathMatcher + ", handler=" + this.handler + ", methodPredicate=" + this.methodPredicate + '}';
    }
}

