/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.WebServer;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ServerResponse {
    public WebServer webServer();

    public Http.ResponseStatus status();

    default public ServerResponse status(int statusCode) throws AlreadyCompletedException {
        return this.status(Http.ResponseStatus.from((int)statusCode));
    }

    public ServerResponse status(Http.ResponseStatus var1) throws AlreadyCompletedException, NullPointerException;

    public ResponseHeaders headers();

    public <T> CompletionStage<ServerResponse> send(T var1);

    public CompletionStage<ServerResponse> send(Flow.Publisher<DataChunk> var1);

    public CompletionStage<ServerResponse> send();

    public <T> ServerResponse registerWriter(Class<T> var1, Function<T, Flow.Publisher<DataChunk>> var2);

    public <T> ServerResponse registerWriter(Class<T> var1, MediaType var2, Function<? extends T, Flow.Publisher<DataChunk>> var3);

    public <T> ServerResponse registerWriter(Predicate<?> var1, Function<T, Flow.Publisher<DataChunk>> var2);

    public <T> ServerResponse registerWriter(Predicate<?> var1, MediaType var2, Function<T, Flow.Publisher<DataChunk>> var3);

    public ServerResponse registerFilter(Function<Flow.Publisher<DataChunk>, Flow.Publisher<DataChunk>> var1);

    public CompletionStage<ServerResponse> whenSent();

    public long requestId();
}

