/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.webserver.ErrorHandler;
import io.helidon.webserver.HandlerRoute;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.NotFoundException;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.Request;
import io.helidon.webserver.Response;
import io.helidon.webserver.Route;
import io.helidon.webserver.RouteList;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.spi.BareRequest;
import io.helidon.webserver.spi.BareResponse;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class RequestRouting
implements Routing {
    private static final Logger LOGGER = Logger.getLogger(RequestRouting.class.getName());
    private final RouteList routes;
    private final List<ErrorHandlerRecord<?>> errorHandlers;
    private final List<Consumer<WebServer>> newWebServerCallbacks;

    RequestRouting(RouteList routes, List<ErrorHandlerRecord<?>> errorHandlers, List<Consumer<WebServer>> newWebServerCallbacks) {
        this.routes = routes;
        this.errorHandlers = errorHandlers;
        this.newWebServerCallbacks = new ArrayList<Consumer<WebServer>>(newWebServerCallbacks);
    }

    @Override
    public void route(BareRequest bareRequest, BareResponse bareResponse) {
        try {
            WebServer webServer = bareRequest.getWebServer();
            Span span = this.createRequestSpan(RequestRouting.tracer(webServer), bareRequest);
            RoutedResponse response = new RoutedResponse(webServer, bareResponse, span.context());
            response.whenSent().thenRun(() -> {
                Http.ResponseStatus httpStatus = response.status();
                if (httpStatus != null) {
                    int statusCode = httpStatus.code();
                    Tags.HTTP_STATUS.set(span, Integer.valueOf(statusCode));
                    if (statusCode >= 400) {
                        Tags.ERROR.set(span, Boolean.valueOf(true));
                        span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"message", (Object)("Response HTTP status: " + statusCode), (Object)"error.kind", (Object)(statusCode < 500 ? "ClientError" : "ServerError")));
                    }
                }
                span.finish();
            }).exceptionally(t -> {
                Tags.ERROR.set(span, Boolean.valueOf(true));
                span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error", (Object)"error.object", (Object)t));
                span.finish();
                return null;
            });
            String p = bareRequest.getUri().normalize().getPath();
            if (p.charAt(p.length() - 1) == '/') {
                p = p.substring(0, p.length() - 1);
            }
            if (p.isEmpty()) {
                p = "/";
            }
            Crawler crawler = new Crawler(this.routes, p, bareRequest.getMethod());
            RoutedRequest nextRequests = new RoutedRequest(bareRequest, response, webServer, crawler, this.errorHandlers, span);
            nextRequests.next();
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Unexpected error occurred during routing!", e);
            throw e;
        }
    }

    private static Tracer tracer(WebServer webServer) {
        ServerConfiguration configuration = webServer.configuration();
        Tracer result = null;
        if (configuration != null) {
            result = configuration.tracer();
        }
        return result == null ? GlobalTracer.get() : result;
    }

    private Span createRequestSpan(Tracer tracer, BareRequest request) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("HTTP Request").withTag(Tags.COMPONENT.getKey(), "helidon-webserver").withTag(Tags.HTTP_METHOD.getKey(), request.getMethod().name()).withTag(Tags.HTTP_URL.getKey(), request.getUri().toString());
        Map<String, String> headersMap = request.getHeaders().entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
        SpanContext spanContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headersMap));
        if (spanContext != null) {
            spanBuilder.asChildOf(spanContext);
        }
        return spanBuilder.start();
    }

    void fireNewWebServer(WebServer webServer) {
        for (Consumer<WebServer> callback : this.newWebServerCallbacks) {
            callback.accept(webServer);
        }
    }

    static class ErrorHandlerRecord<T extends Throwable> {
        private final Class<T> exceptionClass;
        private final ErrorHandler<T> errorHandler;

        private ErrorHandlerRecord(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            this.exceptionClass = exceptionClass;
            this.errorHandler = errorHandler;
        }

        public static <T extends Throwable> ErrorHandlerRecord<T> of(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            return new ErrorHandlerRecord<T>(exceptionClass, errorHandler);
        }
    }

    private static class RoutedResponse
    extends Response {
        private final SpanContext requestSpanContext;

        RoutedResponse(WebServer webServer, BareResponse bareResponse, SpanContext requestSpanContext) {
            super(webServer, bareResponse);
            this.requestSpanContext = requestSpanContext;
        }

        RoutedResponse(RoutedResponse response) {
            super(response);
            this.requestSpanContext = response.requestSpanContext;
        }

        @Override
        SpanContext spanContext() {
            return this.requestSpanContext;
        }
    }

    private static class RoutedRequest
    extends Request {
        private final Crawler crawler;
        private final LinkedList<ErrorHandlerRecord<? extends Throwable>> errorHandlers;
        private final Request.Path path;
        private final RoutedResponse response;
        private final Span requestSpan;
        private final AtomicBoolean nexted = new AtomicBoolean(false);

        RoutedRequest(BareRequest req, RoutedResponse response, WebServer webServer, Crawler crawler, List<ErrorHandlerRecord<?>> errorHandlers, Span requestSpan) {
            super(req, webServer);
            this.crawler = crawler;
            this.errorHandlers = new LinkedList(errorHandlers);
            this.path = null;
            this.response = response;
            this.requestSpan = requestSpan;
        }

        RoutedRequest(RoutedRequest request, RoutedResponse response, Request.Path path, List<ErrorHandlerRecord<?>> errorHandlers) {
            super(request);
            this.crawler = request.crawler;
            this.response = response;
            this.path = path;
            this.errorHandlers = new LinkedList(errorHandlers);
            this.requestSpan = request.requestSpan;
        }

        @Override
        public Span span() {
            return this.requestSpan;
        }

        @Override
        public SpanContext spanContext() {
            return this.requestSpan.context();
        }

        boolean nexted() {
            return this.nexted.get();
        }

        @Override
        public void next() {
            this.checkNexted();
            Crawler.Item nextItem = this.crawler.next();
            if (nextItem == null) {
                this.nextNoCheck(new NotFoundException("No handler found for path: " + this.path()));
            } else {
                try {
                    RoutedResponse nextResponse = new RoutedResponse(this.response);
                    RoutedRequest nextRequest = new RoutedRequest(this, nextResponse, nextItem.path, this.errorHandlers);
                    LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing next: " + nextItem.path);
                    this.requestSpan.log(nextItem.handlerRoute.diagnosticEvent());
                    nextItem.handlerRoute.handler().accept(nextRequest, nextResponse);
                }
                catch (RuntimeException re) {
                    this.nextNoCheck(re);
                }
            }
        }

        private void checkNexted() {
            this.checkNexted(null);
        }

        private void checkNexted(Throwable t) {
            if (!this.nexted.compareAndSet(false, true)) {
                throw new IllegalStateException("The 'next()' method can be called only once!", t);
            }
        }

        private void nextNoCheck(Throwable t) {
            LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing error: " + t.getClass());
            ErrorHandlerRecord<? extends Throwable> record = this.errorHandlers.pollFirst();
            while (record != null) {
                if (((ErrorHandlerRecord)record).exceptionClass.isAssignableFrom(t.getClass())) {
                    ErrorRoutedRequest nextErrorRequest = new ErrorRoutedRequest(this.errorHandlers, t);
                    this.requestSpan.log(CollectionsHelper.mapOf((Object)"event", (Object)"error-handler", (Object)"handler.class", (Object)((ErrorHandlerRecord)record).errorHandler.getClass().getName(), (Object)"handled.error.message", (Object)t.toString()));
                    try {
                        ((ErrorHandlerRecord)record).errorHandler.accept(nextErrorRequest, this.response, t);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Exception unexpectedly thrown from an error handler. Error handling of this logged exception was aborted.", t);
                        this.defaultHandler(new IllegalStateException("Unexpected exception encountered during error handling.", e));
                        return;
                    }
                    return;
                }
                record = this.errorHandlers.pollFirst();
            }
            this.defaultHandler(t);
        }

        private void defaultHandler(Throwable t) {
            this.requestSpan.log(CollectionsHelper.mapOf((Object)"event", (Object)"error-handler", (Object)"handler.class", (Object)"DEFAULT-ERROR-HANDLER", (Object)"handled.error.message", (Object)t.toString()));
            try {
                if (t instanceof HttpException) {
                    this.response.status(((HttpException)t).status());
                } else {
                    LOGGER.log(t instanceof Error ? Level.SEVERE : Level.WARNING, "Default error handler: Unhandled exception encountered.", new ExecutionException("Unhandled 'cause' of this exception encountered.", t));
                    this.response.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
                }
            }
            catch (AlreadyCompletedException e) {
                LOGGER.log(Level.WARNING, "Cannot perform error handling of the throwable (see cause of this exception) because headers were already sent", new IllegalStateException("Headers already sent. Cannot handle the cause of this exception.", t));
            }
            this.response.send().exceptionally(throwable -> {
                LOGGER.log(Level.WARNING, "Default error handler: Response wasn't successfully sent.", (Throwable)throwable);
                return null;
            });
        }

        @Override
        public void next(Throwable t) {
            this.checkNexted();
            this.nextNoCheck(t);
        }

        public HttpRequest.Path path() {
            return this.path;
        }

        @Override
        protected Tracer tracer() {
            return RequestRouting.tracer(this.webServer());
        }

        private class ErrorRoutedRequest
        extends RoutedRequest {
            private final Throwable t;

            ErrorRoutedRequest(LinkedList<ErrorHandlerRecord<?>> errorHandlers, Throwable t) {
                super(RoutedRequest.this, new RoutedResponse(RoutedRequest.this.response), RoutedRequest.this.path, errorHandlers);
                this.t = t;
            }

            @Override
            public void next() {
                super.next(this.t);
            }

            @Override
            public HttpRequest.Path path() {
                return super.path().absolute();
            }
        }
    }

    private static class Crawler {
        private final List<Route> routes;
        private final Request.Path contextPath;
        private final String path;
        private final Http.RequestMethod method;
        private volatile int index = -1;
        private volatile Crawler subCrawler;

        private Crawler(List<Route> routes, Request.Path contextPath, String path, Http.RequestMethod method) {
            this.routes = routes;
            this.path = path;
            this.contextPath = contextPath;
            this.method = method;
        }

        Crawler(List<Route> routes, String path, Http.RequestMethod method) {
            this(routes, null, path, method);
        }

        public Item next() {
            while (this.subCrawler != null || ++this.index < this.routes.size()) {
                if (this.subCrawler != null) {
                    Item result = this.subCrawler.next();
                    if (result != null) {
                        return result;
                    }
                    this.subCrawler = null;
                    continue;
                }
                Route route = this.routes.get(this.index);
                if (route.accepts(this.method)) {
                    RouteList rl;
                    PathMatcher.PrefixResult prefixMatch;
                    if (route instanceof HandlerRoute) {
                        HandlerRoute hr = (HandlerRoute)route;
                        PathMatcher.Result match = hr.match(this.path);
                        if (match.matches()) {
                            return new Item(hr, Request.Path.create(this.contextPath, this.path, match.params()));
                        }
                    } else if (route instanceof RouteList && (prefixMatch = (rl = (RouteList)route).prefixMatch(this.path)).matches()) {
                        this.subCrawler = new Crawler(rl, Request.Path.create(this.contextPath, this.path, prefixMatch.params()), prefixMatch.remainingPart(), this.method);
                        continue;
                    }
                    LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match path: " + this.path);
                    continue;
                }
                LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match method: " + this.method);
            }
            return null;
        }

        private static class Item {
            private final HandlerRoute handlerRoute;
            private final Request.Path path;

            Item(HandlerRoute handlerRoute, Request.Path path) {
                this.handlerRoute = handlerRoute;
                this.path = path;
            }
        }
    }
}

