/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.http.Utils;
import io.helidon.common.reactive.Flow;
import io.helidon.webserver.PublisherInputStream;
import io.helidon.webserver.StringContentReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class ContentReaders {
    private ContentReaders() {
    }

    public static StringContentReader stringReader(Charset charset) {
        StringContentReader reader = (StringContentReader)StringContentReadersHolder.MAP.get(charset.name());
        return reader != null ? reader : new StringContentReader(charset);
    }

    static StringContentReader cachedStringReader(String charset) {
        return (StringContentReader)StringContentReadersHolder.MAP.get(charset);
    }

    public static Reader<byte[]> byteArrayReader() {
        return (publisher, clazz) -> {
            final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            final CompletableFuture future = new CompletableFuture();
            publisher.subscribe((Flow.Subscriber)new Flow.Subscriber<DataChunk>(){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNext(DataChunk item) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = bytes;
                        synchronized (byteArrayOutputStream) {
                            Utils.write((ByteBuffer)item.data(), (OutputStream)bytes);
                        }
                    }
                    catch (IOException e) {
                        this.onError(new IllegalArgumentException("Cannot convert byte buffer to a byte array!", e));
                    }
                    finally {
                        item.release();
                    }
                }

                public void onError(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }

                public void onComplete() {
                    future.complete(bytes.toByteArray());
                }
            });
            return future;
        };
    }

    public static Reader<InputStream> inputStreamReader() {
        return (publisher, clazz) -> CompletableFuture.completedFuture(new PublisherInputStream((Flow.Publisher<DataChunk>)publisher));
    }

    private static final class StringContentReadersHolder {
        private static final Map<String, StringContentReader> MAP = new HashMap<String, StringContentReader>();

        private StringContentReadersHolder() {
        }

        private static void addReader(Charset charset) {
            StringContentReader reader = new StringContentReader(charset);
            MAP.put(charset.name(), reader);
        }

        private static void addReader(String charset) {
            try {
                StringContentReadersHolder.addReader(Charset.forName(charset));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            StringContentReadersHolder.addReader(StandardCharsets.UTF_8);
            StringContentReadersHolder.addReader(StandardCharsets.UTF_16);
            StringContentReadersHolder.addReader(StandardCharsets.ISO_8859_1);
            StringContentReadersHolder.addReader(StandardCharsets.US_ASCII);
            StringContentReadersHolder.addReader("cp1252");
            StringContentReadersHolder.addReader("cp1250");
            StringContentReadersHolder.addReader("ISO-8859-2");
        }
    }
}

