/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.webserver.SSLContextBuilder;
import io.helidon.webserver.ServerBasicConfig;
import io.helidon.webserver.SocketConfiguration;
import io.opentracing.Tracer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public interface ServerConfiguration
extends SocketConfiguration {
    public static final String DEFAULT_SOCKET_NAME = "@default";

    public int workersCount();

    @Override
    public int port();

    @Override
    public InetAddress bindAddress();

    @Override
    public int backlog();

    @Override
    public int timeoutMillis();

    @Override
    public int receiveBufferSize();

    @Override
    public SSLContext ssl();

    default public SocketConfiguration socket(String name) {
        return Optional.ofNullable(this.sockets()).map(map -> (SocketConfiguration)map.get(name)).orElse(null);
    }

    public Map<String, SocketConfiguration> sockets();

    public Tracer tracer();

    public static ServerConfiguration fromConfig(Config config) {
        return ServerConfiguration.builder(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    public static final class Builder
    implements io.helidon.common.Builder<ServerConfiguration> {
        private final SocketConfiguration.Builder defaultSocketBuilder = SocketConfiguration.builder();
        private final Map<String, SocketConfiguration> sockets = new HashMap<String, SocketConfiguration>();
        private int workers;
        private Tracer tracer;

        private Builder() {
        }

        public Builder ssl(SSLContext sslContext) {
            this.defaultSocketBuilder.ssl(sslContext);
            return this;
        }

        public Builder ssl(io.helidon.common.Builder<? extends SSLContext> sslContextBuilder) {
            this.defaultSocketBuilder.ssl(sslContextBuilder);
            return this;
        }

        public Builder port(int port) {
            this.defaultSocketBuilder.port(port);
            return this;
        }

        public Builder bindAddress(InetAddress bindAddress) {
            this.defaultSocketBuilder.bindAddress(bindAddress);
            return this;
        }

        public Builder backlog(int size) {
            this.defaultSocketBuilder.backlog(size);
            return this;
        }

        public Builder timeout(int milliseconds) {
            this.defaultSocketBuilder.timeoutMillis(milliseconds);
            return this;
        }

        public Builder receiveBufferSize(int bytes) {
            this.defaultSocketBuilder.receiveBufferSize(bytes);
            return this;
        }

        public Builder addSocket(String name, int port, InetAddress bindAddress) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, SocketConfiguration.builder().port(port).bindAddress(bindAddress));
        }

        public Builder addSocket(String name, SocketConfiguration socketConfiguration) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            this.sockets.put(name, socketConfiguration != null ? socketConfiguration : SocketConfiguration.DEFAULT);
            return this;
        }

        public Builder addSocket(String name, io.helidon.common.Builder<SocketConfiguration> socketConfigurationBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, socketConfigurationBuilder != null ? (SocketConfiguration)socketConfigurationBuilder.build() : null);
        }

        public Builder workersCount(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder tracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder tracer(io.helidon.common.Builder<? extends Tracer> tracerBuilder) {
            this.tracer = tracerBuilder != null ? (Tracer)tracerBuilder.build() : null;
            return this;
        }

        private InetAddress string2InetAddress(String address) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Illegal value of 'bind-address' configuration key. Expecting host or ip address!", (Throwable)e);
            }
        }

        public Builder config(Config config) {
            if (config == null) {
                return this;
            }
            this.configureSocket(config, this.defaultSocketBuilder);
            config.get("workers").asOptionalInt().ifPresent(this::workersCount);
            Config socketsConfig = config.get("sockets");
            if (socketsConfig.exists()) {
                for (Config socketConfig : socketsConfig.asNodeList(CollectionsHelper.listOf())) {
                    String socketName = socketConfig.name();
                    this.sockets.put(socketName, this.configureSocket(socketConfig, SocketConfiguration.builder()).build());
                }
            }
            return this;
        }

        private SocketConfiguration.Builder configureSocket(Config config, SocketConfiguration.Builder soConfigBuilder) {
            config.get("port").asOptionalInt().ifPresent(soConfigBuilder::port);
            config.get("bind-address").asOptional(String.class).map(this::string2InetAddress).ifPresent(soConfigBuilder::bindAddress);
            config.get("backlog").asOptionalInt().ifPresent(soConfigBuilder::backlog);
            config.get("timeout").asOptionalInt().ifPresent(soConfigBuilder::timeoutMillis);
            config.get("receive-buffer").asOptionalInt().ifPresent(soConfigBuilder::receiveBufferSize);
            Config sslConfig = config.get("ssl");
            if (sslConfig.exists()) {
                try {
                    soConfigBuilder.ssl(SSLContextBuilder.fromConfig(sslConfig));
                }
                catch (IllegalStateException e) {
                    throw new ConfigException("Cannot load SSL configuration.", (Throwable)e);
                }
            }
            return soConfigBuilder;
        }

        public ServerConfiguration build() {
            return new ServerBasicConfig(this.defaultSocketBuilder.build(), this.workers, this.tracer, this.sockets);
        }
    }
}

