/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.common.http.Http;
import io.helidon.webserver.Handler;
import io.helidon.webserver.HandlerRoute;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.PathPattern;
import io.helidon.webserver.Route;
import io.helidon.webserver.RouteList;
import io.helidon.webserver.Routing;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

class RouteListRoutingRules
implements Routing.Rules<RouteListRoutingRules> {
    private final List<Record> records = new ArrayList<Record>();
    private final List<Consumer<WebServer>> newWebServerCallbacks = new ArrayList<Consumer<WebServer>>();
    private final List<Service> contextServices;

    private RouteListRoutingRules(Collection<Service> parentContexts, Service service) {
        if (parentContexts == null || parentContexts.isEmpty()) {
            this.contextServices = service == null ? Collections.emptyList() : Collections.singletonList(service);
        } else {
            this.contextServices = new ArrayList<Service>(parentContexts.size() + 1);
            this.contextServices.addAll(parentContexts);
            if (service != null) {
                this.contextServices.add(service);
            }
        }
    }

    RouteListRoutingRules() {
        this(null, null);
    }

    Aggregation aggregate(PathMatcher pathContext) {
        ArrayList<Route> result = new ArrayList<Route>();
        ArrayList<Consumer<WebServer>> resultCallbacks = new ArrayList<Consumer<WebServer>>(this.newWebServerCallbacks);
        for (Record record : this.records) {
            if (record.route != null) {
                result.add(record.route);
                continue;
            }
            if (record.services == null) continue;
            ArrayList<Aggregation> subAggregations = new ArrayList<Aggregation>();
            for (Service service : record.services) {
                Aggregation aggr;
                RouteListRoutingRules rules = new RouteListRoutingRules(this.contextServices, service);
                service.update(rules);
                if (rules.isEmpty() || (aggr = rules.aggregate(record.pathContext)).isEmpty()) continue;
                subAggregations.add(aggr);
            }
            if (subAggregations.isEmpty()) continue;
            Aggregation subAggregation = Aggregation.concatWithSamePath(subAggregations);
            resultCallbacks.addAll(subAggregation.getNewWebServerCallbacks());
            if (subAggregation.getRouteList().isEmpty()) continue;
            if (record.pathContext == null) {
                result.addAll(subAggregation.getRouteList());
                continue;
            }
            result.add(subAggregation.getRouteList());
        }
        return new Aggregation(new RouteList(pathContext, result), resultCallbacks);
    }

    Aggregation aggregate() {
        return this.aggregate(null);
    }

    private boolean isEmpty() {
        return this.records.isEmpty() && this.newWebServerCallbacks.isEmpty() && this.contextServices.isEmpty();
    }

    @Override
    public RouteListRoutingRules onNewWebServer(Consumer<WebServer> webServerConsumer) {
        if (webServerConsumer != null) {
            this.newWebServerCallbacks.add(webServerConsumer);
        }
        return this;
    }

    @Override
    public RouteListRoutingRules register(Service ... services) {
        if (services != null && services.length > 0) {
            this.records.add(new Record(null, services));
        }
        return this;
    }

    @Override
    public RouteListRoutingRules register(Builder<? extends Service> ... serviceBuilders) {
        if (serviceBuilders != null && serviceBuilders.length > 0) {
            this.records.add(new Record(null, (Service[])Stream.of(serviceBuilders).filter(Objects::nonNull).map(Builder::build).toArray(Service[]::new)));
        }
        return this;
    }

    @Override
    public RouteListRoutingRules register(String pathPattern, Service ... services) {
        if (services != null && services.length > 0) {
            this.records.add(new Record(PathPattern.compile(pathPattern), services));
        }
        return this;
    }

    @Override
    public RouteListRoutingRules register(String pathPattern, Builder<? extends Service> ... serviceBuilders) {
        if (serviceBuilders != null && serviceBuilders.length > 0) {
            this.records.add(new Record(PathPattern.compile(pathPattern), (Service[])Stream.of(serviceBuilders).filter(Objects::nonNull).map(Builder::build).toArray(Service[]::new)));
        }
        return this;
    }

    private RouteListRoutingRules addSingle(Http.RequestMethod method, PathMatcher pathMatcher, Handler ... requestHandlers) {
        if (requestHandlers != null) {
            for (Handler requestHandler : requestHandlers) {
                if (pathMatcher == null) {
                    this.records.add(new Record(new HandlerRoute(this.contextServices, requestHandler, method)));
                    continue;
                }
                this.records.add(new Record(new HandlerRoute(this.contextServices, pathMatcher, requestHandler, method)));
            }
        }
        return this;
    }

    private RouteListRoutingRules addSingle(Http.RequestMethod method, String pathPattern, Handler ... requestHandlers) {
        if (pathPattern != null) {
            return this.addSingle(method, PathPattern.compile(pathPattern), requestHandlers);
        }
        return this.addSingle(method, (PathMatcher)null, requestHandlers);
    }

    private RouteListRoutingRules addSingle(Http.RequestMethod method, Handler ... requestHandlers) {
        return this.addSingle(method, (PathMatcher)null, requestHandlers);
    }

    @Override
    public RouteListRoutingRules get(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.GET, requestHandlers);
    }

    @Override
    public RouteListRoutingRules get(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.GET, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules get(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.GET, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules put(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.PUT, requestHandlers);
    }

    @Override
    public RouteListRoutingRules put(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.PUT, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules put(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.GET, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules post(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.PUT, requestHandlers);
    }

    @Override
    public RouteListRoutingRules post(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.POST, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules post(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.POST, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules delete(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.DELETE, requestHandlers);
    }

    @Override
    public RouteListRoutingRules delete(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.DELETE, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules delete(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.DELETE, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules options(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.OPTIONS, requestHandlers);
    }

    @Override
    public RouteListRoutingRules options(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.OPTIONS, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules options(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.OPTIONS, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules head(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.HEAD, requestHandlers);
    }

    @Override
    public RouteListRoutingRules head(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.HEAD, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules head(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.HEAD, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules trace(Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.TRACE, requestHandlers);
    }

    @Override
    public RouteListRoutingRules trace(String pathPattern, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.TRACE, pathPattern, requestHandlers);
    }

    @Override
    public RouteListRoutingRules trace(PathMatcher pathMatcher, Handler ... requestHandlers) {
        return this.addSingle((Http.RequestMethod)Http.Method.TRACE, pathMatcher, requestHandlers);
    }

    @Override
    public RouteListRoutingRules any(Handler ... requestHandlers) {
        return this.any((PathMatcher)null, requestHandlers);
    }

    @Override
    public RouteListRoutingRules any(String pathPattern, Handler ... requestHandlers) {
        if (pathPattern == null) {
            return this.any((PathMatcher)null, requestHandlers);
        }
        return this.any(PathMatcher.from(pathPattern), requestHandlers);
    }

    @Override
    public RouteListRoutingRules any(PathMatcher pathMatcher, Handler ... requestHandlers) {
        if (requestHandlers != null) {
            for (Handler requestHandler : requestHandlers) {
                if (pathMatcher == null) {
                    this.records.add(new Record(new HandlerRoute(this.contextServices, requestHandler, new Http.RequestMethod[0])));
                    continue;
                }
                this.records.add(new Record(new HandlerRoute(this.contextServices, pathMatcher, requestHandler, new Http.RequestMethod[0])));
            }
        }
        return this;
    }

    @Override
    public RouteListRoutingRules anyOf(Iterable<Http.RequestMethod> methods, Handler ... requestHandlers) {
        return this.anyOf((Iterable)methods, (PathMatcher)null, requestHandlers);
    }

    @Override
    public RouteListRoutingRules anyOf(Iterable<Http.RequestMethod> methods, String pathPattern, Handler ... requestHandlers) {
        if (pathPattern == null) {
            return this.anyOf((Iterable)methods, (PathMatcher)null, requestHandlers);
        }
        return this.anyOf((Iterable)methods, PathMatcher.from(pathPattern), requestHandlers);
    }

    @Override
    public RouteListRoutingRules anyOf(Iterable<Http.RequestMethod> methods, PathMatcher pathMatcher, Handler ... requestHandlers) {
        if (requestHandlers != null) {
            for (Handler requestHandler : requestHandlers) {
                if (pathMatcher == null) {
                    this.records.add(new Record(new HandlerRoute(this.contextServices, requestHandler, methods)));
                    continue;
                }
                this.records.add(new Record(new HandlerRoute(this.contextServices, pathMatcher, requestHandler, methods)));
            }
        }
        return this;
    }

    static class Aggregation {
        private final RouteList routeList;
        private final List<Consumer<WebServer>> newWebServerCallbacks;

        private Aggregation(RouteList routeList, List<Consumer<WebServer>> newWebServerCallbacks) {
            this.routeList = routeList;
            this.newWebServerCallbacks = newWebServerCallbacks;
        }

        RouteList getRouteList() {
            return this.routeList;
        }

        boolean isEmpty() {
            return this.routeList.isEmpty() && this.newWebServerCallbacks.isEmpty();
        }

        List<Consumer<WebServer>> getNewWebServerCallbacks() {
            return this.newWebServerCallbacks;
        }

        private static Aggregation concatWithSamePath(List<Aggregation> aggregations) {
            if (aggregations == null || aggregations.isEmpty()) {
                throw new IllegalArgumentException("Parameter aggregations is null or empty!");
            }
            if (aggregations.size() == 1) {
                return aggregations.get(0);
            }
            ArrayList<Consumer<WebServer>> callbacks = new ArrayList<Consumer<WebServer>>();
            ArrayList<Route> routes = new ArrayList<Route>();
            for (Aggregation aggregation : aggregations) {
                callbacks.addAll(aggregation.newWebServerCallbacks);
                routes.addAll(aggregation.routeList);
            }
            return new Aggregation(new RouteList(aggregations.get((int)0).routeList.getPathContext(), routes), callbacks);
        }
    }

    private static class Record {
        private final Route route;
        private final PathMatcher pathContext;
        private final Service[] services;

        Record(Route route) {
            this.route = route;
            this.pathContext = null;
            this.services = null;
        }

        Record(PathMatcher pathContext, Service[] services) {
            this.route = null;
            this.pathContext = pathContext;
            this.services = services;
        }
    }
}

