/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.DateTime;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.websocket.WsConfig;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.webserver.websocket.WsUpgrader;
import io.helidon.websocket.ClientWsFrame;
import io.helidon.websocket.ServerWsFrame;
import io.helidon.websocket.WsCloseException;
import io.helidon.websocket.WsListener;
import io.helidon.websocket.WsOpCode;
import io.helidon.websocket.WsSession;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.Semaphore;

public class WsConnection
implements ServerConnection,
WsSession {
    private static final System.Logger LOGGER = System.getLogger(WsConnection.class.getName());
    static final int MAX_FRAME_LENGTH = 0x100000;
    private final ConnectionContext ctx;
    private final HttpPrologue prologue;
    private final Headers upgradeHeaders;
    private final String wsKey;
    private final WsListener listener;
    private final WsConfig wsConfig;
    private final BufferData sendBuffer = BufferData.growing((int)1024);
    private final DataReader dataReader;
    private ContinuationType recvContinuation = ContinuationType.NONE;
    private boolean sendContinuation;
    private boolean closeSent;
    private volatile Thread myThread;
    private volatile boolean canRun = true;
    private volatile boolean readingNetwork;
    private volatile ZonedDateTime lastRequestTimestamp;

    private WsConnection(ConnectionContext ctx, HttpPrologue prologue, Headers upgradeHeaders, String wsKey, WsListener wsListener) {
        this.ctx = ctx;
        this.prologue = prologue;
        this.upgradeHeaders = upgradeHeaders;
        this.wsKey = wsKey;
        this.listener = wsListener;
        this.dataReader = ctx.dataReader();
        this.lastRequestTimestamp = DateTime.timestamp();
        this.wsConfig = (WsConfig)ctx.listenerContext().config().protocols().stream().filter(p -> p instanceof WsConfig).findFirst().orElseThrow(() -> new InternalError("Unable to find WebSocket config"));
    }

    public static WsConnection create(ConnectionContext ctx, HttpPrologue prologue, Headers upgradeHeaders, String wsKey, WsListener wsListener) {
        return new WsConnection(ctx, prologue, upgradeHeaders, wsKey, wsListener);
    }

    public static WsConnection create(ConnectionContext ctx, HttpPrologue prologue, Headers upgradeHeaders, String wsKey, WsRoute wsRoute) {
        return new WsConnection(ctx, prologue, upgradeHeaders, wsKey, wsRoute.listener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Semaphore requestSemaphore) {
        this.myThread = Thread.currentThread();
        this.listener.onOpen((WsSession)this);
        if (requestSemaphore.tryAcquire()) {
            try {
                while (this.canRun) {
                    block11: {
                        this.readingNetwork = true;
                        ClientWsFrame frame = this.readFrame();
                        this.readingNetwork = false;
                        this.lastRequestTimestamp = DateTime.timestamp();
                        if (this.processFrame(frame)) break block11;
                        this.lastRequestTimestamp = DateTime.timestamp();
                        return;
                    }
                    try {
                        this.lastRequestTimestamp = DateTime.timestamp();
                    }
                    catch (CloseConnectionException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.listener.onError((WsSession)this, (Throwable)e);
                        this.close(1011, e.getMessage());
                        requestSemaphore.release();
                        return;
                    }
                }
                this.close(1000, "Idle timeout");
            }
            finally {
                requestSemaphore.release();
            }
        }
        this.listener.onClose((WsSession)this, 1013, "Too Many Concurrent Requests");
    }

    public WsSession send(String text, boolean last) {
        return this.send(ServerWsFrame.data((String)text, (boolean)last));
    }

    public WsSession send(BufferData bufferData, boolean last) {
        return this.send(ServerWsFrame.data((BufferData)bufferData, (boolean)last));
    }

    public WsSession ping(BufferData bufferData) {
        return this.send(ServerWsFrame.control((WsOpCode)WsOpCode.PING, (BufferData)bufferData));
    }

    public WsSession pong(BufferData bufferData) {
        return this.send(ServerWsFrame.control((WsOpCode)WsOpCode.PONG, (BufferData)bufferData));
    }

    public WsSession close(int code, String reason) {
        this.closeSent = true;
        byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
        BufferData bufferData = BufferData.create((int)(2 + reasonBytes.length));
        bufferData.writeInt16(code);
        bufferData.write(reasonBytes);
        return this.send(ServerWsFrame.control((WsOpCode)WsOpCode.CLOSE, (BufferData)bufferData));
    }

    public WsSession terminate() {
        this.close(1000, "Terminate");
        throw new CloseConnectionException("Terminate from WebSocket");
    }

    public Optional<String> subProtocol() {
        return this.upgradeHeaders.first(WsUpgrader.PROTOCOL);
    }

    public Duration idleTime() {
        return Duration.between(this.lastRequestTimestamp, DateTime.timestamp());
    }

    public void close(boolean interrupt) {
        this.canRun = false;
        if (interrupt) {
            if (this.myThread != null) {
                this.myThread.interrupt();
            }
        } else if (this.readingNetwork) {
            this.myThread.interrupt();
        }
    }

    private boolean processFrame(ClientWsFrame frame) {
        BufferData payload = frame.payloadData();
        block0 : switch (frame.opCode()) {
            case CONTINUATION: {
                boolean finalFrame = frame.fin();
                ContinuationType ct = this.recvContinuation;
                if (finalFrame) {
                    this.recvContinuation = ContinuationType.NONE;
                }
                switch (ct.ordinal()) {
                    case 1: {
                        this.listener.onMessage((WsSession)this, payload.readString(payload.available(), StandardCharsets.UTF_8), finalFrame);
                        break block0;
                    }
                    case 2: {
                        this.listener.onMessage((WsSession)this, payload, finalFrame);
                        break block0;
                    }
                }
                this.close(1002, "Unexpected continuation received");
                throw new CloseConnectionException("Websocket unexpected continuation");
            }
            case TEXT: {
                this.recvContinuation = ContinuationType.TEXT;
                this.listener.onMessage((WsSession)this, payload.readString(payload.available(), StandardCharsets.UTF_8), frame.fin());
                break;
            }
            case BINARY: {
                this.recvContinuation = ContinuationType.BINARY;
                this.listener.onMessage((WsSession)this, payload, frame.fin());
                break;
            }
            case CLOSE: {
                int status = 1000;
                String reason = "normal";
                if (payload.available() > 0) {
                    status = payload.readInt16();
                    if (payload.available() > 0) {
                        reason = payload.readString(payload.available(), StandardCharsets.UTF_8);
                    }
                }
                this.listener.onClose((WsSession)this, status, reason);
                if (!this.closeSent) {
                    this.close(1000, "normal");
                }
                return false;
            }
            case PING: {
                this.listener.onPing((WsSession)this, payload);
                break;
            }
            case PONG: {
                this.listener.onPong((WsSession)this, payload);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid frame opCode: " + String.valueOf(frame.opCode()));
            }
        }
        return true;
    }

    private ClientWsFrame readFrame() {
        try {
            return ClientWsFrame.read((SocketContext)this.ctx, (DataReader)this.dataReader, (int)this.wsConfig.maxFrameLength());
        }
        catch (DataReader.InsufficientDataAvailableException e) {
            throw new CloseConnectionException("Socket closed by the other side", (Throwable)e);
        }
        catch (WsCloseException e) {
            this.close(e.closeCode(), e.getMessage());
            throw new CloseConnectionException("WebSocket failed to read client frame", (Throwable)e);
        }
    }

    private WsSession send(ServerWsFrame frame) {
        WsOpCode usedCode = frame.opCode();
        if (frame.isPayload()) {
            if (this.sendContinuation) {
                usedCode = WsOpCode.CONTINUATION;
            }
            this.sendContinuation = !frame.fin();
        }
        frame.opCode(usedCode);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            this.ctx.log(LOGGER, System.Logger.Level.TRACE, "ws server frame send %s", new Object[]{frame});
        }
        this.sendBuffer.clear();
        int opCodeFull = frame.fin() ? 128 : 0;
        this.sendBuffer.write(opCodeFull |= usedCode.code());
        long length = frame.payloadLength();
        if (length < 126L) {
            this.sendBuffer.write((int)length);
        } else if (length < 65536L) {
            this.sendBuffer.write(126);
            this.sendBuffer.write((int)(length >>> 8));
            this.sendBuffer.write((int)(length & 0xFFL));
        } else {
            this.sendBuffer.write(127);
            for (int i = 56; i >= 0; i -= 8) {
                this.sendBuffer.write((int)(length >>> i) & 0xFF);
            }
        }
        this.sendBuffer.write(frame.payloadData());
        this.ctx.dataWriter().writeNow(this.sendBuffer);
        return this;
    }

    private static enum ContinuationType {
        NONE,
        TEXT,
        BINARY;

    }
}

