/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.http.DirectHandler;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.NotFoundException;
import io.helidon.http.RequestException;
import io.helidon.http.WritableHeaders;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Routing;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.websocket.WsConfig;
import io.helidon.webserver.websocket.WsConnection;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.webserver.websocket.WsRouting;
import io.helidon.websocket.WsListener;
import io.helidon.websocket.WsUpgradeException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import java.util.Set;

public class WsUpgrader
implements Http1Upgrader {
    public static final HeaderName WS_KEY = HeaderNames.create((String)"Sec-WebSocket-Key");
    public static final HeaderName WS_VERSION = HeaderNames.create((String)"Sec-WebSocket-Version");
    public static final HeaderName PROTOCOL = HeaderNames.create((String)"Sec-WebSocket-Protocol");
    public static final HeaderName EXTENSIONS = HeaderNames.create((String)"Sec-WebSocket-Extensions");
    protected static final String SWITCHING_PROTOCOL_PREFIX = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: websocket\r\nSec-WebSocket-Accept: ";
    protected static final String SWITCHING_PROTOCOLS_SUFFIX = "\r\n\r\n";
    protected static final String SUPPORTED_VERSION = "13";
    protected static final Header SUPPORTED_VERSION_HEADER = HeaderValues.create((HeaderName)WS_VERSION, (String)"13");
    static final Headers EMPTY_HEADERS = WritableHeaders.create();
    private static final System.Logger LOGGER = System.getLogger(WsUpgrader.class.getName());
    private static final byte[] KEY_SUFFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.US_ASCII);
    private static final int KEY_SUFFIX_LENGTH = KEY_SUFFIX.length;
    private static final Base64.Decoder B64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder B64_ENCODER = Base64.getEncoder();
    private static final byte[] HEADERS_SEPARATOR = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private final Set<String> origins;
    private final boolean anyOrigin;

    protected WsUpgrader(WsConfig wsConfig) {
        this.origins = wsConfig.origins();
        this.anyOrigin = this.origins.isEmpty();
    }

    public static WsUpgrader create(WsConfig config) {
        return new WsUpgrader(config);
    }

    public String supportedProtocol() {
        return "websocket";
    }

    public ServerConnection upgrade(ConnectionContext ctx, HttpPrologue prologue, WritableHeaders<?> headers) {
        Optional upgradeHeaders;
        WsRoute route;
        if (!headers.contains(WS_KEY)) {
            return null;
        }
        String wsKey = headers.get(WS_KEY).value();
        String version = headers.contains(WS_VERSION) ? headers.get(WS_VERSION).value() : SUPPORTED_VERSION;
        if (!SUPPORTED_VERSION.equals(version)) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Unsupported WebSocket Version").header(SUPPORTED_VERSION_HEADER).build();
        }
        try {
            route = ((WsRouting)ctx.router().routing(WsRouting.class, (Routing)WsRouting.empty())).findRoute(prologue);
        }
        catch (NotFoundException e) {
            return null;
        }
        if (!this.anyOrigin() && headers.contains(HeaderNames.ORIGIN)) {
            String origin = headers.get(HeaderNames.ORIGIN).value();
            if (!this.origins().contains(origin)) {
                throw RequestException.builder().message("Invalid Origin").type(DirectHandler.EventType.FORBIDDEN).build();
            }
        }
        WsListener wsListener = route.listener();
        try {
            upgradeHeaders = wsListener.onHttpUpgrade(prologue, headers);
        }
        catch (WsUpgradeException e) {
            LOGGER.log(System.Logger.Level.TRACE, "Websocket upgrade rejected", (Throwable)e);
            return null;
        }
        DataWriter dataWriter = ctx.dataWriter();
        String switchingProtocols = SWITCHING_PROTOCOL_PREFIX + this.hash(ctx, wsKey);
        dataWriter.write(BufferData.create((byte[])switchingProtocols.getBytes(StandardCharsets.US_ASCII)));
        BufferData separator = BufferData.create((byte[])HEADERS_SEPARATOR);
        dataWriter.write(separator);
        upgradeHeaders.ifPresent(hs -> {
            BufferData headerData = BufferData.growing((int)128);
            hs.forEach(h -> h.writeHttp1Header(headerData));
            dataWriter.write(headerData);
        });
        dataWriter.write(separator.rewind());
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Upgraded to websocket version " + version);
        }
        return WsConnection.create(ctx, prologue, upgradeHeaders.orElse(EMPTY_HEADERS), wsKey, wsListener);
    }

    protected boolean anyOrigin() {
        return this.anyOrigin;
    }

    protected Set<String> origins() {
        return this.origins;
    }

    protected String hash(ConnectionContext ctx, String wsKey) {
        byte[] decodedBytes = B64_DECODER.decode(wsKey);
        if (decodedBytes.length != 16) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Invalid Sec-WebSocket-Key header").build();
        }
        byte[] wsKeyBytes = wsKey.getBytes(StandardCharsets.US_ASCII);
        int wsKeyBytesLength = wsKeyBytes.length;
        byte[] toHash = new byte[wsKeyBytesLength + KEY_SUFFIX_LENGTH];
        System.arraycopy(wsKeyBytes, 0, toHash, 0, wsKeyBytesLength);
        System.arraycopy(KEY_SUFFIX, 0, toHash, wsKeyBytesLength, KEY_SUFFIX_LENGTH);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            return B64_ENCODER.encodeToString(digest.digest(toHash));
        }
        catch (NoSuchAlgorithmException e) {
            ctx.log(LOGGER, System.Logger.Level.ERROR, "SHA-1 must be provided for WebSocket to work", (Throwable)e, new Object[0]);
            throw new IllegalStateException("SHA-1 not provided", e);
        }
    }
}

