/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.websocket.WsConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.websocket.WsConfigBlueprint")
public interface WsConfig
extends WsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WsConfig instance) {
        return (Builder)WsConfig.builder().from(instance);
    }

    public static WsConfig create(Config config) {
        return ((Builder)WsConfig.builder().config(config)).buildPrototype();
    }

    public static WsConfig create() {
        return WsConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WsConfig>
    implements io.helidon.common.Builder<Builder, WsConfig> {
        private Builder() {
        }

        public WsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WsConfigImpl(this);
        }

        public WsConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WsConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<String> origins = new LinkedHashSet<String>();
        private Config config;
        private int maxFrameLength = 0x100000;
        private String name = "websocket";

        protected BuilderBase() {
        }

        public BUILDER from(WsConfig prototype) {
            this.addOrigins(prototype.origins());
            this.name(prototype.name());
            this.maxFrameLength(prototype.maxFrameLength());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addOrigins(builder.origins());
            this.name(builder.name());
            this.maxFrameLength(builder.maxFrameLength());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("origins").asList(String.class).map(Set::copyOf).ifPresent(this::origins);
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("max-frame-length").as(Integer.class).ifPresent(this::maxFrameLength);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER origins(Set<? extends String> origins) {
            Objects.requireNonNull(origins);
            this.origins.clear();
            this.origins.addAll(origins);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOrigins(Set<? extends String> origins) {
            Objects.requireNonNull(origins);
            this.origins.addAll(origins);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOrigin(String origin) {
            Objects.requireNonNull(origin);
            this.origins.add(origin);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxFrameLength(int maxFrameLength) {
            this.maxFrameLength = maxFrameLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Set<String> origins() {
            return this.origins;
        }

        public String name() {
            return this.name;
        }

        public int maxFrameLength() {
            return this.maxFrameLength;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "WsConfigBuilder{origins=" + String.valueOf(this.origins) + ",name=" + this.name + ",maxFrameLength=" + this.maxFrameLength + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class WsConfigImpl
        implements WsConfig {
            private final int maxFrameLength;
            private final Set<String> origins;
            private final String name;

            protected WsConfigImpl(BuilderBase<?, ?> builder) {
                this.origins = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.origins()));
                this.name = builder.name();
                this.maxFrameLength = builder.maxFrameLength();
            }

            @Override
            public Set<String> origins() {
                return this.origins;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public int maxFrameLength() {
                return this.maxFrameLength;
            }

            public String toString() {
                return "WsConfig{origins=" + String.valueOf(this.origins) + ",name=" + this.name + ",maxFrameLength=" + this.maxFrameLength + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WsConfig)) {
                    return false;
                }
                WsConfig other = (WsConfig)o;
                return Objects.equals(this.origins, other.origins()) && Objects.equals(this.name, other.name()) && this.maxFrameLength == other.maxFrameLength();
            }

            public int hashCode() {
                return Objects.hash(this.origins, this.name, this.maxFrameLength);
            }
        }
    }
}

