/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.common.http.Http;
import io.helidon.webserver.ForwardingHandler;
import io.helidon.webserver.websocket.WebSocketHandler;
import io.helidon.webserver.websocket.WebSocketRouting;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;

class WebSocketUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private static final Logger LOGGER = Logger.getLogger(WebSocketUpgradeCodec.class.getName());
    private static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private final WebSocketRouting webSocketRouting;
    private String path;
    private WebSocketHandler wsHandler;

    WebSocketUpgradeCodec(WebSocketRouting webSocketRouting) {
        this.webSocketRouting = webSocketRouting;
    }

    public Collection<CharSequence> requiredUpgradeHeaders() {
        return List.of("Upgrade");
    }

    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeResponseHeaders) {
        try {
            this.path = upgradeRequest.uri();
            upgradeResponseHeaders.remove("Upgrade");
            upgradeResponseHeaders.remove("Connection");
            this.wsHandler = new WebSocketHandler(ctx, this.path, upgradeRequest, upgradeResponseHeaders, this.webSocketRouting);
            TyrusUpgradeResponse upgradeResponse = this.wsHandler.upgradeResponse();
            if (upgradeResponse.getStatus() != Http.Status.SWITCHING_PROTOCOLS_101.code()) {
                Map upgradeHeaders = upgradeResponse.getHeaders();
                upgradeHeaders.remove("Upgrade");
                upgradeHeaders.remove("Connection");
                upgradeHeaders.remove(SEC_WEBSOCKET_ACCEPT);
                upgradeHeaders.remove(SEC_WEBSOCKET_PROTOCOL);
                DefaultHttpHeaders headers = new DefaultHttpHeaders();
                upgradeHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
                headers.add("Content-Type", (Object)"text/plain");
                String reasonPhrase = upgradeResponse.getReasonPhrase() == null ? "" : upgradeResponse.getReasonPhrase();
                DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)upgradeResponse.getStatus()), Unpooled.wrappedBuffer((byte[])reasonPhrase.getBytes(Charset.defaultCharset())), (HttpHeaders)headers, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
                ChannelFuture writeComplete = ctx.writeAndFlush((Object)httpResponse);
                writeComplete.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return false;
            }
        }
        catch (Throwable cause) {
            LOGGER.log(Level.SEVERE, "Error during upgrade to WebSocket", cause);
            return false;
        }
        return true;
    }

    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
        if (ctx.pipeline().get(ForwardingHandler.class) != null) {
            ctx.pipeline().remove(ForwardingHandler.class);
        }
        ctx.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.path, null, true)});
        ctx.pipeline().addLast(new ChannelHandler[]{this.wsHandler});
        ctx.pipeline().remove("io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler");
        this.wsHandler.open(ctx);
    }
}

