/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.tyrus;

import io.helidon.common.http.Parameters;
import io.helidon.common.http.UriComponent;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.tyrus.TyrusReaderSubscriber;
import io.helidon.webserver.tyrus.TyrusWriterPublisher;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusSupport
implements Service {
    private static final Logger LOGGER = Logger.getLogger(TyrusSupport.class.getName());
    private static final ByteBuffer FLUSH_BUFFER = ByteBuffer.allocateDirect(0);
    private final WebSocketEngine engine;
    private final TyrusHandler handler = new TyrusHandler();
    private Set<Class<?>> endpointClasses;
    private Set<ServerEndpointConfig> endpointConfigs;
    private Set<Extension> extensions;

    protected TyrusSupport(TyrusSupport other) {
        this.engine = other.engine;
        this.endpointClasses = other.endpointClasses;
        this.endpointConfigs = other.endpointConfigs;
        this.extensions = other.extensions;
    }

    TyrusSupport(WebSocketEngine engine, Set<Class<?>> endpointClasses, Set<ServerEndpointConfig> endpointConfigs, Set<Extension> extensions) {
        this.engine = engine;
        this.endpointClasses = endpointClasses;
        this.endpointConfigs = endpointConfigs;
        this.extensions = extensions;
    }

    public void update(Routing.Rules routingRules) {
        LOGGER.info("Updating TyrusSupport routing routes");
        routingRules.any(new Handler[]{this.handler});
    }

    public Set<Class<?>> endpointClasses() {
        return Collections.unmodifiableSet(this.endpointClasses);
    }

    public Set<ServerEndpointConfig> endpointConfigs() {
        return Collections.unmodifiableSet(this.endpointConfigs);
    }

    public Set<Extension> extensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    protected ExecutorService executorService() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private class TyrusHandler
    implements Handler {
        private TyrusHandler() {
        }

        public void accept(ServerRequest req, ServerResponse res) {
            String reason;
            Optional secWebSocketKey = req.headers().value("Sec-WebSocket-Key");
            if (secWebSocketKey.isEmpty()) {
                req.next();
                return;
            }
            LOGGER.fine("Initiating WebSocket handshake ...");
            HashMap paramsMap = new HashMap();
            Parameters params = UriComponent.decodeQuery((String)req.uri().getRawQuery(), (boolean)true);
            params.toMap().forEach((key, value) -> paramsMap.put(key, value.toArray(new String[0])));
            RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(req.path().toString())).queryString(req.query()).parameterMap(paramsMap).build();
            req.headers().toMap().forEach((key, value) -> requestContext.getHeaders().put(key, value));
            TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
            WebSocketEngine.UpgradeInfo upgradeInfo = TyrusSupport.this.engine.upgrade((UpgradeRequest)requestContext, (UpgradeResponse)upgradeResponse);
            res.status(upgradeResponse.getStatus());
            upgradeResponse.getHeaders().forEach((key, value) -> res.headers().add(key, (Iterable)value));
            TyrusWriterPublisher publisherWriter = new TyrusWriterPublisher();
            res.headers().send().forSingle(responseHeaders -> res.send((Flow.Publisher)publisherWriter));
            if (upgradeInfo.getStatus() != WebSocketEngine.UpgradeStatus.SUCCESS && (reason = upgradeResponse.getReasonPhrase()) != null) {
                publisherWriter.write(ByteBuffer.wrap(reason.getBytes(StandardCharsets.UTF_8)), null);
            }
            publisherWriter.write(FLUSH_BUFFER, null);
            ExecutorService executorService = TyrusSupport.this.executorService();
            if (executorService != null) {
                CompletableFuture<Connection> future = CompletableFuture.supplyAsync(() -> upgradeInfo.createConnection((Writer)publisherWriter, closeReason -> LOGGER.fine(() -> "Connection closed: " + closeReason)), executorService);
                future.thenAccept(c -> {
                    TyrusReaderSubscriber subscriber = new TyrusReaderSubscriber((Connection)c, executorService);
                    req.content().subscribe((Flow.Subscriber)subscriber);
                });
            } else {
                Connection connection = upgradeInfo.createConnection((Writer)publisherWriter, closeReason -> LOGGER.fine(() -> "Connection closed: " + closeReason));
                if (connection != null) {
                    TyrusReaderSubscriber subscriber = new TyrusReaderSubscriber(connection);
                    req.content().subscribe((Flow.Subscriber)subscriber);
                }
            }
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<TyrusSupport> {
        private Set<Class<?>> endpointClasses = new HashSet();
        private Set<ServerEndpointConfig> endpointConfigs = new HashSet<ServerEndpointConfig>();
        private Set<Extension> extensions = new HashSet<Extension>();

        private Builder() {
        }

        public Builder register(Class<?> endpointClass) {
            this.endpointClasses.add(endpointClass);
            return this;
        }

        public Builder register(ServerEndpointConfig endpointConfig) {
            this.endpointConfigs.add(endpointConfig);
            return this;
        }

        public Builder register(Extension extension) {
            this.extensions.add(extension);
            return this;
        }

        public TyrusSupport build() {
            final HashSet<Extension> installedExtensions = new HashSet<Extension>(this.extensions);
            TyrusServerContainer serverContainer = new TyrusServerContainer(this.endpointClasses){
                private final WebSocketEngine engine;
                {
                    super(arg0);
                    this.engine = TyrusWebSocketEngine.builder((WebSocketContainer)this).build();
                }

                public void register(Class<?> endpointClass) {
                    throw new UnsupportedOperationException("Use TyrusWebSocketEngine for registration");
                }

                public void register(ServerEndpointConfig serverEndpointConfig) {
                    throw new UnsupportedOperationException("Use TyrusWebSocketEngine for registration");
                }

                public Set<Extension> getInstalledExtensions() {
                    return installedExtensions;
                }

                public WebSocketEngine getWebSocketEngine() {
                    return this.engine;
                }
            };
            WebSocketEngine engine = serverContainer.getWebSocketEngine();
            this.endpointClasses.forEach(c -> {
                try {
                    engine.register(c, "/");
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            });
            this.endpointConfigs.forEach(c -> {
                try {
                    engine.register(c, "/");
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            });
            return new TyrusSupport(serverContainer.getWebSocketEngine(), this.endpointClasses, this.endpointConfigs, this.extensions);
        }
    }
}

