/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.tyrus;

import io.helidon.common.http.DataChunk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

public class TyrusWriterPublisher
extends Writer
implements Flow.Publisher<DataChunk> {
    private Flow.Subscriber<? super DataChunk> subscriber;
    private final Queue<QueuedBuffer> queue = new ConcurrentLinkedQueue<QueuedBuffer>();
    private final AtomicLong requested = new AtomicLong(0L);

    public void write(ByteBuffer byteBuffer, CompletionHandler<ByteBuffer> handler) {
        if (this.subscriber == null) {
            return;
        }
        if (this.requested.get() <= 0L) {
            this.queue.add(new QueuedBuffer(byteBuffer, handler));
            return;
        }
        while (!this.queue.isEmpty() && this.requested.get() > 0L) {
            QueuedBuffer queuedBuffer = this.queue.remove();
            this.writeNext(queuedBuffer.byteBuffer(), queuedBuffer.completionHandler());
            TyrusWriterPublisher.decrement(this.requested);
        }
        if (this.requested.get() > 0L) {
            this.writeNext(byteBuffer, handler);
            TyrusWriterPublisher.decrement(this.requested);
        } else {
            this.queue.add(new QueuedBuffer(byteBuffer, handler));
        }
    }

    public void close() throws IOException {
        if (this.subscriber != null) {
            this.subscriber.onComplete();
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super DataChunk> newSubscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("Only one subscriber is allowed");
        }
        this.subscriber = newSubscriber;
        this.subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (n == Long.MAX_VALUE) {
                    TyrusWriterPublisher.this.requested.set(Long.MAX_VALUE);
                } else {
                    TyrusWriterPublisher.this.requested.getAndAdd(n);
                }
            }

            @Override
            public void cancel() {
                TyrusWriterPublisher.this.requested.set(0L);
            }
        });
    }

    private static synchronized long decrement(AtomicLong requested) {
        long value = requested.get();
        return value == Long.MAX_VALUE ? requested.get() : requested.decrementAndGet();
    }

    private void writeNext(ByteBuffer byteBuffer, CompletionHandler<ByteBuffer> handler) {
        DataChunk dataChunk = DataChunk.create((boolean)true, (ByteBuffer)byteBuffer, (boolean)true);
        if (handler != null) {
            dataChunk.writeFuture(TyrusWriterPublisher.fromCompletionHandler(handler));
        }
        this.subscriber.onNext((DataChunk)dataChunk);
    }

    private static CompletableFuture<DataChunk> fromCompletionHandler(CompletionHandler<ByteBuffer> handler) {
        CompletableFuture<DataChunk> future = new CompletableFuture<DataChunk>();
        future.whenComplete((chunk, throwable) -> {
            if (throwable == null) {
                handler.completed((Object)chunk.data());
            } else {
                handler.failed(throwable);
            }
        });
        return future;
    }

    private static class QueuedBuffer {
        private final CompletionHandler<ByteBuffer> completionHandler;
        private final ByteBuffer byteBuffer;

        QueuedBuffer(ByteBuffer byteBuffer, CompletionHandler<ByteBuffer> completionHandler) {
            this.byteBuffer = byteBuffer;
            this.completionHandler = completionHandler;
        }

        CompletionHandler<ByteBuffer> completionHandler() {
            return this.completionHandler;
        }

        ByteBuffer byteBuffer() {
            return this.byteBuffer;
        }
    }
}

