/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MediaSupport;
import io.helidon.webserver.BackpressureStrategy;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.Routing;
import io.helidon.webserver.testsupport.TestRequest;
import io.helidon.webserver.testsupport.TestResponse;
import io.helidon.webserver.testsupport.TestWebServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class TestClient {
    private static final Duration TIMEOUT = Duration.ofMinutes(10L);
    private final Routing routing;
    private final MediaContext mediaContext;

    private TestClient(Routing routing, MediaContext mediaContext) {
        Objects.requireNonNull(routing, "Parameter 'routing' is null!");
        this.routing = routing;
        this.mediaContext = mediaContext;
    }

    public static TestClient create(Supplier<Routing> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return TestClient.create(routingBuilder.get());
    }

    public static TestClient create(Routing routing, MediaContext mediaContext) {
        return new TestClient(routing, mediaContext);
    }

    public static TestClient create(Routing routing, MediaSupport mediaSupport) {
        MediaContext mediaContext = MediaContext.builder().addMediaSupport(mediaSupport).build();
        return TestClient.create(routing, mediaContext);
    }

    public static TestClient create(Routing routing) {
        return new TestClient(routing, null);
    }

    public TestRequest path(String path) {
        return new TestRequest(this, path);
    }

    TestResponse call(Http.RequestMethod method, Http.Version version, URI path, Map<String, List<String>> headers, Flow.Publisher<DataChunk> publisher) throws InterruptedException, TimeoutException {
        TestWebServer webServer = new TestWebServer(this.mediaContext);
        TestBareRequest req = new TestBareRequest(method, version, path, headers, publisher, webServer);
        TestBareResponse res = new TestBareResponse(webServer);
        Contexts.runInContext((Context)Context.create((Context)webServer.context()), () -> this.routing.route((BareRequest)req, (BareResponse)res));
        try {
            return res.responseFuture.get(TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ee.getCause();
            }
            throw new RuntimeException("Unexpected routing issue.", ee.getCause());
        }
    }

    private static class TestBareRequest
    implements BareRequest {
        private final Http.RequestMethod method;
        private final Http.Version version;
        private final URI path;
        private final Map<String, List<String>> headers;
        private final Flow.Publisher<DataChunk> publisher;
        private final TestWebServer webServer;

        TestBareRequest(Http.RequestMethod method, Http.Version version, URI path, Map<String, List<String>> headers, Flow.Publisher<DataChunk> publisher, TestWebServer webServer) {
            this.webServer = Objects.requireNonNull(webServer, "webServer 'webServer' is null!");
            this.method = Objects.requireNonNull(method, "Parameter 'method' is null!");
            this.version = Objects.requireNonNull(version, "Parameter 'version' is null!");
            this.path = Objects.requireNonNull(path, "Parameter 'path' is null!");
            this.headers = new ReadOnlyParameters(headers).toMap();
            this.publisher = publisher == null ? Single.empty() : publisher;
        }

        public TestWebServer webServer() {
            return this.webServer;
        }

        public Http.RequestMethod method() {
            return this.method;
        }

        public Http.Version version() {
            return this.version;
        }

        public URI uri() {
            return this.path;
        }

        public String localAddress() {
            return "0.0.0.0";
        }

        public int localPort() {
            return 9999;
        }

        public String remoteAddress() {
            return "127.0.0.1";
        }

        public int remotePort() {
            return 3333;
        }

        public boolean isSecure() {
            return false;
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public Flow.Publisher<DataChunk> bodyPublisher() {
            return this.publisher;
        }

        public long requestId() {
            return 0L;
        }

        public Single<Void> closeConnection() {
            throw new UnsupportedOperationException();
        }
    }

    static class TestBareResponse
    implements BareResponse {
        private final CompletableFuture<TestResponse> responseFuture = new CompletableFuture();
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final CompletableFuture<BareResponse> headersCompletionStage = new CompletableFuture();
        private final CompletableFuture<BareResponse> completionStage = new CompletableFuture();
        private final TestWebServer webServer;
        private volatile Flow.Subscription subscription;

        TestBareResponse(TestWebServer webServer) {
            this.webServer = webServer;
        }

        TestWebServer webServer() {
            return this.webServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] asBytes() {
            ByteArrayOutputStream byteArrayOutputStream = this.baos;
            synchronized (byteArrayOutputStream) {
                return this.baos.toByteArray();
            }
        }

        public void writeStatusAndHeaders(Http.ResponseStatus status, Map<String, List<String>> headers) {
            this.headersCompletionStage.complete(this);
            this.responseFuture.complete(new TestResponse(status, headers, this));
        }

        public Single<BareResponse> whenHeadersCompleted() {
            return Single.create(this.headersCompletionStage);
        }

        public Single<BareResponse> whenCompleted() {
            return Single.create(this.completionStage);
        }

        public void backpressureStrategy(BackpressureStrategy backpressureStrategy) {
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(DataChunk data) {
            if (data == null) {
                return;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.baos;
                synchronized (byteArrayOutputStream) {
                    for (ByteBuffer byteBuffer : data.data()) {
                        byte[] buff = new byte[byteBuffer.remaining()];
                        byteBuffer.get(buff);
                        this.baos.write(buff);
                    }
                }
            }
            catch (IOException e) {
                this.onError(new IllegalStateException("Cannot write data into the ByteArrayOutputStream!", e));
            }
        }

        public void onError(Throwable thr) {
            try {
                this.subscription.cancel();
            }
            finally {
                this.headersCompletionStage.completeExceptionally(thr);
                this.completionStage.completeExceptionally(thr);
            }
        }

        public void onComplete() {
            try {
                this.subscription.cancel();
            }
            finally {
                this.headersCompletionStage.complete(this);
                this.completionStage.complete(this);
            }
        }

        public long requestId() {
            return 0L;
        }
    }
}

