/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class TemporaryFolder {
    private File rootFolder;

    public File newFile(String name) throws IOException {
        File result = new File(this.rootFolder, name);
        if (!result.createNewFile()) {
            throw new IllegalStateException("file already exist: " + result.getAbsolutePath());
        }
        return result;
    }

    public File newFolder(String name) {
        File result = new File(this.rootFolder, name);
        if (!result.mkdir()) {
            throw new IllegalStateException("directory was not created: " + result.getAbsolutePath());
        }
        return result;
    }

    public File root() {
        return this.rootFolder;
    }

    void prepare() {
        try {
            this.rootFolder = File.createTempFile("junit5-", ".tmp");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (!this.rootFolder.delete()) {
            throw new IllegalStateException("directory was not deleted: " + this.rootFolder.getAbsolutePath());
        }
        if (!this.rootFolder.mkdir()) {
            throw new IllegalStateException("directory was not created: " + this.rootFolder.getAbsolutePath());
        }
    }

    void cleanUp() {
        if (this.rootFolder.exists()) {
            try {
                Files.walkFileTree(this.rootFolder.toPath(), new DeleteAllVisitor());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    private static class DeleteAllVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteAllVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }
    }
}

