/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.context.Context;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerTls;
import java.util.concurrent.CompletableFuture;

class TestWebServer
implements WebServer {
    private static final MediaContext DEFAULT_MEDIA_SUPPORT = MediaContext.create();
    private final CompletableFuture<WebServer> startFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> shutdownFuture = new CompletableFuture();
    private final Context context = Context.create();
    private final ServerConfiguration configuration = ServerConfiguration.builder().build();
    private final MediaContext mediaContext;

    TestWebServer() {
        this.mediaContext = DEFAULT_MEDIA_SUPPORT;
    }

    TestWebServer(MediaContext mediaContext) {
        this.mediaContext = mediaContext == null ? DEFAULT_MEDIA_SUPPORT : mediaContext;
    }

    public ServerConfiguration configuration() {
        return this.configuration;
    }

    public Single<WebServer> start() {
        if (this.shutdownFuture.isDone()) {
            throw new IllegalStateException("Cannot start over!");
        }
        this.startFuture.complete(this);
        return Single.create(this.startFuture);
    }

    public Single<WebServer> shutdown() {
        this.shutdownFuture.complete(this);
        return Single.create(this.shutdownFuture);
    }

    public Single<WebServer> whenShutdown() {
        return Single.create(this.shutdownFuture);
    }

    public boolean isRunning() {
        return !this.shutdownFuture.isDone();
    }

    public Context context() {
        return this.context;
    }

    public MessageBodyReaderContext readerContext() {
        return this.mediaContext.readerContext();
    }

    public MessageBodyWriterContext writerContext() {
        return this.mediaContext.writerContext();
    }

    public int port(String name) {
        return 0;
    }

    public void updateTls(WebServerTls tls) {
    }

    public void updateTls(WebServerTls tls, String socketName) {
    }

    public boolean hasTls(String socketName) {
        return false;
    }
}

