/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.http.ContextualRegistry;
import io.helidon.media.common.MediaSupport;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.WebServer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class TestWebServer
implements WebServer {
    private final CompletableFuture<WebServer> startFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> shutdownFuture = new CompletableFuture();
    private final ServerConfiguration configuration = ServerConfiguration.builder().build();
    private final ContextualRegistry context = ContextualRegistry.create();
    private final MediaSupport mediaSupport = MediaSupport.createWithDefaults();

    TestWebServer() {
    }

    public ServerConfiguration configuration() {
        return this.configuration;
    }

    public MediaSupport mediaSupport() {
        return this.mediaSupport;
    }

    public CompletionStage<WebServer> start() {
        if (this.shutdownFuture.isDone()) {
            throw new IllegalStateException("Cannot start over!");
        }
        this.startFuture.complete(this);
        return this.startFuture;
    }

    public CompletionStage<WebServer> shutdown() {
        this.shutdownFuture.complete(this);
        return this.shutdownFuture;
    }

    public CompletionStage<WebServer> whenShutdown() {
        return this.shutdownFuture;
    }

    public boolean isRunning() {
        return !this.shutdownFuture.isDone();
    }

    public ContextualRegistry context() {
        return this.context;
    }

    public int port(String name) {
        return 0;
    }
}

