/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Flow;

public interface MediaPublisher
extends Flow.Publisher<DataChunk> {
    public MediaType mediaType();

    public static MediaPublisher create(final MediaType publishedType, final Flow.Publisher<DataChunk> publisher) {
        return new MediaPublisher(){

            @Override
            public MediaType mediaType() {
                return publishedType;
            }

            @Override
            public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
                publisher.subscribe(subscriber);
            }
        };
    }

    public static MediaPublisher create(final MediaType publishedType, CharSequence charSequence) {
        ByteBuffer data = Optional.ofNullable(publishedType).flatMap(MediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8).encode(charSequence.toString());
        Multi publisher = Multi.just((Object[])new DataChunk[]{DataChunk.create((ByteBuffer)data)});
        return new MediaPublisher((Flow.Publisher)publisher){
            final /* synthetic */ Flow.Publisher val$publisher;
            {
                this.val$publisher = publisher;
            }

            @Override
            public MediaType mediaType() {
                return publishedType;
            }

            @Override
            public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
                this.val$publisher.subscribe(subscriber);
            }
        };
    }
}

