/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.webserver.testsupport.TemporaryFolder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class TemporaryFolderExtension
implements AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private final Collection<TemporaryFolder> tempFolders = new ArrayList<TemporaryFolder>();

    public void afterEach(ExtensionContext context) throws IOException {
        this.tempFolders.forEach(TemporaryFolder::cleanUp);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getType() == TemporaryFolder.class).forEach(field -> this.injectTemporaryFolder(testInstance, (Field)field));
    }

    private void injectTemporaryFolder(Object instance, Field field) {
        field.setAccessible(true);
        try {
            field.set(instance, this.createTempFolder());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == TemporaryFolder.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.createTempFolder();
    }

    private TemporaryFolder createTempFolder() {
        TemporaryFolder result = new TemporaryFolder();
        result.prepare();
        this.tempFolders.add(result);
        return result;
    }
}

