/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ReactiveStreamsAdapter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface MediaPublisher
extends Flow.Publisher<DataChunk> {
    public MediaType mediaType();

    public static MediaPublisher create(final MediaType publishedType, final Flow.Publisher<DataChunk> publisher) {
        return new MediaPublisher(){

            @Override
            public MediaType mediaType() {
                return publishedType;
            }

            public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
                publisher.subscribe(subscriber);
            }
        };
    }

    public static MediaPublisher create(final MediaType publishedType, CharSequence charSequence) {
        ByteBuffer data = Optional.ofNullable(publishedType).flatMap(MediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8).encode(charSequence.toString());
        final Flow.Publisher publisher = ReactiveStreamsAdapter.publisherToFlow((Publisher)Flux.just((Object)DataChunk.create((ByteBuffer)data)));
        return new MediaPublisher(){

            @Override
            public MediaType mediaType() {
                return publishedType;
            }

            public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
                publisher.subscribe(subscriber);
            }
        };
    }
}

