/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testsupport;

import io.helidon.webserver.Http;
import io.helidon.webserver.MediaType;
import io.helidon.webserver.Parameters;
import io.helidon.webserver.ReadOnlyParameters;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.testsupport.TestClient;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TestResponse {
    private final Http.ResponseStatus status;
    private final Parameters headers;
    private final TestClient.TestBareResponse bareResponse;

    TestResponse(Http.ResponseStatus status, Map<String, List<String>> headers, TestClient.TestBareResponse bareResponse) {
        this.status = status;
        this.headers = new ReadOnlyParameters(headers);
        this.bareResponse = bareResponse;
    }

    public Http.ResponseStatus status() {
        return this.status;
    }

    public Parameters headers() {
        return this.headers;
    }

    public CompletableFuture<byte[]> asBytes() {
        return this.bareResponse.whenCompleted().thenApply(br -> this.bareResponse.asBytes()).toCompletableFuture();
    }

    public CompletableFuture<String> asString() {
        Charset charset = this.headers.first("Content-Type").map(MediaType::parse).flatMap(MediaType::getCharset).map(s -> {
            try {
                return Charset.forName(s);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(StandardCharsets.UTF_8);
        return this.asBytes().thenApply(bts -> new String((byte[])bts, charset));
    }

    public WebServer webServer() {
        return this.bareResponse.getWebServer();
    }
}

