/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.LruCacheConfig;
import io.helidon.common.media.type.MediaType;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.ClassPathContentHandler;
import io.helidon.webserver.staticcontent.FileSystemContentHandler;
import io.helidon.webserver.staticcontent.SingleFileContentHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public interface StaticContentService
extends HttpService {
    public static ClassPathBuilder builder(String resourceRoot) {
        Objects.requireNonNull(resourceRoot, "Attribute resourceRoot is null!");
        return StaticContentService.builder(resourceRoot, Thread.currentThread().getContextClassLoader());
    }

    public static ClassPathBuilder builder(String resourceRoot, ClassLoader classLoader) {
        Objects.requireNonNull(resourceRoot, "Attribute resourceRoot is null!");
        return new ClassPathBuilder().root(resourceRoot).classLoader(classLoader);
    }

    public static FileSystemBuilder builder(Path root) {
        Objects.requireNonNull(root, "Attribute root is null!");
        return new FileSystemBuilder().root(root);
    }

    public static StaticContentService create(String resourceRoot) {
        return StaticContentService.create(resourceRoot, Thread.currentThread().getContextClassLoader());
    }

    public static StaticContentService create(String resourceRoot, ClassLoader classLoader) {
        return StaticContentService.builder(resourceRoot, classLoader).build();
    }

    public static StaticContentService create(Path root) {
        return StaticContentService.builder(root).build();
    }

    public static class ClassPathBuilder
    extends FileBasedBuilder<ClassPathBuilder> {
        private String clRoot;
        private ClassLoader classLoader;
        private Path tmpDir;

        protected ClassPathBuilder() {
        }

        public ClassPathBuilder tmpDir(Path tmpDir) {
            this.tmpDir = tmpDir;
            return this;
        }

        @Override
        protected StaticContentService doBuild() {
            return new ClassPathContentHandler(this);
        }

        ClassPathBuilder classLoader(ClassLoader cl) {
            this.classLoader = cl;
            return this;
        }

        ClassPathBuilder root(String root) {
            Objects.requireNonNull(root, "Attribute root is null!");
            String cleanRoot = root;
            if (cleanRoot.startsWith("/")) {
                cleanRoot = cleanRoot.substring(1);
            }
            while (cleanRoot.endsWith("/")) {
                cleanRoot = cleanRoot.substring(0, cleanRoot.length() - 1);
            }
            if (cleanRoot.isEmpty()) {
                throw new IllegalArgumentException("Cannot serve full classpath, please configure a classpath prefix");
            }
            this.clRoot = cleanRoot;
            return this;
        }

        String root() {
            return this.clRoot;
        }

        ClassLoader classLoader() {
            return this.classLoader;
        }

        Path tmpDir() {
            return this.tmpDir;
        }
    }

    public static class FileSystemBuilder
    extends FileBasedBuilder<FileSystemBuilder> {
        private Path root;

        protected FileSystemBuilder() {
        }

        @Override
        protected StaticContentService doBuild() {
            if (this.root == null) {
                throw new NullPointerException("Root path must be defined");
            }
            if (Files.isDirectory(this.root, new LinkOption[0])) {
                return new FileSystemContentHandler(this);
            }
            return new SingleFileContentHandler(this);
        }

        FileSystemBuilder root(Path root) {
            Objects.requireNonNull(root, "Attribute root is null!");
            this.root = root.toAbsolutePath().normalize();
            if (!Files.exists(this.root, new LinkOption[0])) {
                throw new IllegalArgumentException("Cannot create file system static content, path " + String.valueOf(this.root) + " does not exist.");
            }
            return this;
        }

        Path root() {
            return this.root;
        }
    }

    public static abstract class FileBasedBuilder<T extends FileBasedBuilder<T>>
    extends Builder<FileBasedBuilder<T>> {
        private final Map<String, MediaType> specificContentTypes = new TreeMap<String, MediaType>(String.CASE_INSENSITIVE_ORDER);

        protected FileBasedBuilder() {
        }

        public T contentType(String filenameExtension, MediaType contentType) {
            Objects.requireNonNull(filenameExtension, "Parameter 'filenameExtension' is null!");
            Objects.requireNonNull(contentType, "Parameter 'contentType' is null!");
            filenameExtension = filenameExtension.trim();
            if (filenameExtension.startsWith(".")) {
                filenameExtension = filenameExtension.substring(1);
            }
            if (filenameExtension.isEmpty()) {
                throw new IllegalArgumentException("Parameter 'filenameExtension' cannot be empty!");
            }
            this.specificContentTypes.put(filenameExtension, contentType);
            return (T)this;
        }

        Map<String, MediaType> specificContentTypes() {
            return this.specificContentTypes;
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    implements io.helidon.common.Builder<B, StaticContentService> {
        private String welcomeFileName;
        private Function<String, String> resolvePathFunction = Function.identity();
        private Set<String> cacheInMemory = new HashSet<String>();
        private LruCache<String, CachedHandler> handlerCache;

        protected Builder() {
        }

        public final StaticContentService build() {
            return this.doBuild();
        }

        public B welcomeFileName(String welcomeFileName) {
            Objects.requireNonNull(welcomeFileName, "Welcome file cannot be null");
            if (welcomeFileName.isBlank()) {
                throw new IllegalArgumentException("Welcome file cannot be empty");
            }
            this.welcomeFileName = welcomeFileName;
            return (B)((Builder)this.identity());
        }

        public B pathMapper(Function<String, String> resolvePathFunction) {
            this.resolvePathFunction = resolvePathFunction;
            return (B)((Builder)this.identity());
        }

        public B addCacheInMemory(String path) {
            this.cacheInMemory.add(path);
            return (B)((Builder)this.identity());
        }

        public B recordCacheCapacity(int capacity) {
            this.handlerCache = ((LruCacheConfig.Builder)LruCache.builder().capacity(capacity)).build();
            return (B)((Builder)this.identity());
        }

        protected abstract StaticContentService doBuild();

        String welcomeFileName() {
            return this.welcomeFileName;
        }

        Function<String, String> resolvePathFunction() {
            return this.resolvePathFunction;
        }

        Set<String> cacheInMemory() {
            return this.cacheInMemory;
        }

        LruCache<String, CachedHandler> handlerCache() {
            return this.handlerCache == null ? LruCache.create() : this.handlerCache;
        }
    }
}

