/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.media.type.MediaType;
import io.helidon.http.DateTime;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpException;
import io.helidon.http.InternalServerException;
import io.helidon.http.Method;
import io.helidon.http.NotFoundException;
import io.helidon.http.PathMatchers;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.webserver.staticcontent.StaticContentService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class StaticContentHandler
implements StaticContentService {
    private static final System.Logger LOGGER = System.getLogger(StaticContentHandler.class.getName());
    private final Map<String, CachedHandlerInMemory> inMemoryCache = new ConcurrentHashMap<String, CachedHandlerInMemory>();
    private final LruCache<String, CachedHandler> handlerCache;
    private final String welcomeFilename;
    private final Function<String, String> resolvePathFunction;
    private final AtomicInteger webServerCounter = new AtomicInteger();

    StaticContentHandler(StaticContentService.Builder<?> builder) {
        this.welcomeFilename = builder.welcomeFileName();
        this.resolvePathFunction = builder.resolvePathFunction();
        this.handlerCache = builder.handlerCache();
    }

    static void processEtag(String etag, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders) {
        List ifMatches;
        if (etag == null || etag.isEmpty()) {
            return;
        }
        etag = StaticContentHandler.unquoteETag(etag);
        responseHeaders.set(HeaderNames.ETAG, new String[]{"\"" + etag + "\""});
        if (requestHeaders.contains(HeaderNames.IF_NONE_MATCH)) {
            List ifNoneMatches = requestHeaders.get(HeaderNames.IF_NONE_MATCH).allValues();
            for (String ifNoneMatch : ifNoneMatches) {
                if (!"*".equals(ifNoneMatch = StaticContentHandler.unquoteETag(ifNoneMatch)) && !ifNoneMatch.equals(etag)) continue;
                throw new HttpException("Accepted by If-None-Match header", Status.NOT_MODIFIED_304, true);
            }
        }
        if (requestHeaders.contains(HeaderNames.IF_MATCH) && !(ifMatches = requestHeaders.get(HeaderNames.IF_MATCH).allValues()).isEmpty()) {
            boolean ifMatchChecked = false;
            for (String ifMatch : ifMatches) {
                if (!"*".equals(ifMatch = StaticContentHandler.unquoteETag(ifMatch)) && !ifMatch.equals(etag)) continue;
                ifMatchChecked = true;
                break;
            }
            if (!ifMatchChecked) {
                throw new HttpException("Not accepted by If-Match header", Status.PRECONDITION_FAILED_412, true);
            }
        }
    }

    static void processModifyHeaders(Instant modified, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders, BiConsumer<ServerResponseHeaders, Instant> setModified) {
        if (modified == null) {
            return;
        }
        setModified.accept(responseHeaders, modified);
        Optional<Instant> ifModSince = requestHeaders.ifModifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifModSince.isPresent() && !ifModSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Modified-Since header", Status.NOT_MODIFIED_304, true);
        }
        Optional<Instant> ifUnmodSince = requestHeaders.ifUnmodifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifUnmodSince.isPresent() && ifUnmodSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Unmodified-Since header", Status.PRECONDITION_FAILED_412, true);
        }
    }

    static void processModifyHeaders(Instant modified, ServerRequestHeaders requestHeaders, ServerResponseHeaders responseHeaders) {
        StaticContentHandler.processModifyHeaders(modified, requestHeaders, responseHeaders, ServerResponseHeaders::lastModified);
    }

    static void throwNotFoundIf(boolean condition) {
        if (condition) {
            throw new NotFoundException("Static content not found");
        }
    }

    public void beforeStart() {
        this.webServerCounter.incrementAndGet();
    }

    public void afterStop() {
        int i = this.webServerCounter.decrementAndGet();
        if (i <= 0) {
            this.webServerCounter.set(0);
            this.releaseCache();
        }
    }

    public void routing(HttpRules rules) {
        rules.route((Predicate)Method.predicate((Method[])new Method[]{Method.GET, Method.HEAD}), PathMatchers.any(), this::handle);
    }

    void releaseCache() {
        this.handlerCache.clear();
        this.inMemoryCache.clear();
    }

    void handle(ServerRequest request, ServerResponse response) {
        Method method = request.prologue().method();
        String requestPath = request.path().rawPathNoParams();
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        String origPath = requestPath;
        boolean mapped = !(requestPath = this.resolvePathFunction.apply(requestPath)).equals(origPath);
        try {
            if (!this.doHandle(method, requestPath, request, response, mapped)) {
                response.next();
            }
        }
        catch (HttpException httpException) {
            if (httpException.status().code() == Status.NOT_FOUND_404.code()) {
                response.next();
            }
            throw httpException;
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to access static resource", (Throwable)e);
            throw new InternalServerException("Cannot access static resource", (Throwable)e);
        }
    }

    abstract boolean doHandle(Method var1, String var2, ServerRequest var3, ServerResponse var4, boolean var5) throws IOException, URISyntaxException;

    String welcomePageName() {
        return this.welcomeFilename;
    }

    void cacheInMemory(String resource, CachedHandlerInMemory handler) {
        this.inMemoryCache.put(resource, handler);
    }

    Optional<CachedHandlerInMemory> cacheInMemory(String resource) {
        return Optional.ofNullable(this.inMemoryCache.get(resource));
    }

    Optional<CachedHandler> cacheHandler(String resource) {
        return this.cacheInMemory(resource).map(CachedHandler.class::cast).or(() -> this.handlerCache.get((Object)resource));
    }

    void cacheHandler(String resource, CachedHandler cachedResource) {
        this.handlerCache.put((Object)resource, (Object)cachedResource);
    }

    LruCache<String, CachedHandler> handlerCache() {
        return this.handlerCache;
    }

    private static String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    void cacheInMemory(String resource, MediaType contentType, byte[] bytes, Optional<Instant> lastModified) {
        CachedHandlerInMemory inMemoryResource;
        int contentLength = bytes.length;
        Header contentLengthHeader = HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (int)contentLength);
        if (lastModified.isEmpty()) {
            inMemoryResource = new CachedHandlerInMemory(contentType, null, null, bytes, contentLength, contentLengthHeader);
        } else {
            Header lastModifiedHeader = HeaderValues.create((HeaderName)HeaderNames.LAST_MODIFIED, (boolean)true, (boolean)false, (String[])new String[]{StaticContentHandler.formatLastModified(lastModified.get())});
            inMemoryResource = new CachedHandlerInMemory(contentType, lastModified.get(), (headers, instant) -> headers.set(lastModifiedHeader), bytes, contentLength, contentLengthHeader);
        }
        this.cacheInMemory(resource, inMemoryResource);
    }

    static String formatLastModified(Instant lastModified) {
        ZonedDateTime dt = ZonedDateTime.ofInstant(lastModified, ZoneId.systemDefault());
        return dt.format(DateTime.RFC_1123_DATE_TIME);
    }
}

