/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.http.Http;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.webserver.staticcontent.CachedHandlerPath;
import io.helidon.webserver.staticcontent.CachedHandlerRedirect;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.StaticContentService;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

class FileSystemContentHandler
extends FileBasedContentHandler {
    private static final System.Logger LOGGER = System.getLogger(FileSystemContentHandler.class.getName());
    private final AtomicBoolean populatedInMemoryCache = new AtomicBoolean();
    private final Path root;
    private final Set<String> cacheInMemory;

    FileSystemContentHandler(StaticContentService.FileSystemBuilder builder) {
        super(builder);
        this.root = builder.root().toAbsolutePath().normalize();
        this.cacheInMemory = new HashSet<String>(builder.cacheInMemory());
    }

    @Override
    public void beforeStart() {
        if (this.populatedInMemoryCache.compareAndSet(false, true)) {
            for (String resource : this.cacheInMemory) {
                try {
                    this.addToInMemoryCache(resource);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to add file to in-memory cache", (Throwable)e);
                }
            }
        }
        super.beforeStart();
    }

    @Override
    void releaseCache() {
        this.populatedInMemoryCache.set(false);
    }

    @Override
    boolean doHandle(Http.Method method, String requestedPath, ServerRequest req, ServerResponse res, boolean mapped) throws IOException {
        Path path = this.requestedPath(requestedPath);
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Requested file: " + String.valueOf(path.toAbsolutePath()));
        }
        if (!path.startsWith(this.root)) {
            return false;
        }
        String rawPath = req.prologue().uriPath().rawPath();
        String relativePath = this.root.relativize(path).toString();
        Object requestedResource = mapped ? relativePath : (rawPath.endsWith("/") ? relativePath + "/" : relativePath);
        Optional<CachedHandler> cached = this.cacheHandler((String)requestedResource);
        if (cached.isPresent()) {
            return cached.get().handle(this.handlerCache(), method, req, res, (String)requestedResource);
        }
        return this.doHandle(method, (String)requestedResource, req, res, rawPath, path);
    }

    boolean doHandle(Http.Method method, String requestedResource, ServerRequest req, ServerResponse res, String rawPath, Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        String welcomeFileName = this.welcomePageName();
        if (welcomeFileName != null && Files.isDirectory(path, new LinkOption[0])) {
            String welcomeFileResource = requestedResource + (requestedResource.endsWith("/") ? "" : "/") + welcomeFileName;
            if (rawPath.endsWith("/")) {
                Optional<CachedHandlerInMemory> inMemoryMaybe = this.cacheInMemory(welcomeFileResource);
                if (inMemoryMaybe.isPresent()) {
                    this.cacheInMemory(requestedResource, inMemoryMaybe.get());
                    return inMemoryMaybe.get().handle(this.handlerCache(), method, req, res, requestedResource);
                }
                path = FileSystemContentHandler.resolveWelcomeFile(path, this.welcomePageName());
            } else {
                String redirectLocation = rawPath + "/";
                CachedHandlerRedirect handler = new CachedHandlerRedirect(redirectLocation);
                this.cacheHandler(requestedResource, handler);
                return handler.handle(this.handlerCache(), method, req, res, requestedResource);
            }
        }
        CachedHandlerPath handler = new CachedHandlerPath(path, this.detectType(FileSystemContentHandler.fileName(path)), FileBasedContentHandler::lastModified, ServerResponseHeaders::lastModified);
        this.cacheHandler(requestedResource, handler);
        return handler.handle(this.handlerCache(), method, req, res, requestedResource);
    }

    private void addToInMemoryCache(String resource) throws IOException {
        Path path = this.requestedPath(resource);
        if (!path.startsWith(this.root)) {
            LOGGER.log(System.Logger.Level.WARNING, "File " + resource + " cannot be added to in memory cache, as it is not within the root directory.");
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.log(System.Logger.Level.WARNING, "File " + resource + " cannot be added to in memory cache, as it does not exist");
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
                paths.forEach(child -> {
                    if (!Files.isDirectory(child, new LinkOption[0])) {
                        String childResource = this.root.relativize((Path)child).toString().replace('\\', '/');
                        try {
                            this.addToInMemoryCache(childResource, (Path)child);
                        }
                        catch (IOException e) {
                            LOGGER.log(System.Logger.Level.WARNING, "File " + String.valueOf(child) + " cannot be added to in memory cache", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            this.addToInMemoryCache(resource, path);
        }
    }

    private void addToInMemoryCache(String resource, Path path) throws IOException {
        byte[] fileBytes = Files.readAllBytes(path);
        this.cacheInMemory(resource, this.detectType(FileSystemContentHandler.fileName(path)), fileBytes, FileSystemContentHandler.lastModified(path));
    }

    private Path requestedPath(String requestedPath) {
        if (requestedPath.isEmpty()) {
            return this.root;
        }
        return this.root.resolve(requestedPath).toAbsolutePath().normalize();
    }
}

