/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.media.type.MediaType;
import io.helidon.http.Http;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;

record CachedHandlerUrlStream(MediaType mediaType, URL url) implements CachedHandler
{
    private static final System.Logger LOGGER = System.getLogger(CachedHandlerUrlStream.class.getName());

    @Override
    public boolean handle(LruCache<String, CachedHandler> cache, Http.Method method, ServerRequest request, ServerResponse response, String requestedResource) throws IOException {
        URLConnection urlConnection;
        long lastModified;
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Sending static content using stream from classpath: " + String.valueOf(this.url));
        }
        if ((lastModified = (urlConnection = this.url.openConnection()).getLastModified()) != 0L) {
            StaticContentHandler.processEtag(String.valueOf(lastModified), request.headers(), response.headers());
            StaticContentHandler.processModifyHeaders(Instant.ofEpochMilli(lastModified), request.headers(), response.headers());
        }
        response.headers().contentType(this.mediaType);
        if (method == Http.Method.HEAD) {
            response.send();
            return true;
        }
        try (InputStream in = this.url.openStream();
             OutputStream outputStream = response.outputStream();){
            in.transferTo(outputStream);
        }
        return true;
    }
}

