/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.media.type.MediaType;
import io.helidon.http.ForbiddenException;
import io.helidon.http.Http;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.IoFunction;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.function.BiConsumer;

record CachedHandlerPath(Path path, MediaType mediaType, IoFunction<Path, Optional<Instant>> lastModified, BiConsumer<ServerResponseHeaders, Instant> setLastModifiedHeader) implements CachedHandler
{
    private static final System.Logger LOGGER = System.getLogger(CachedHandlerPath.class.getName());

    @Override
    public boolean handle(LruCache<String, CachedHandler> cache, Http.Method method, ServerRequest request, ServerResponse response, String requestedResource) throws IOException {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Sending static content from path: " + String.valueOf(this.path));
        }
        if (!Files.exists(this.path, new LinkOption[0]) || !Files.isRegularFile(this.path, new LinkOption[0]) || !Files.isReadable(this.path) || Files.isHidden(this.path)) {
            cache.remove((Object)requestedResource);
            throw new ForbiddenException("File is not accessible");
        }
        Instant lastModified = this.lastModified().apply(this.path).orElse(null);
        if (lastModified != null) {
            StaticContentHandler.processEtag(String.valueOf(lastModified.toEpochMilli()), request.headers(), response.headers());
            StaticContentHandler.processModifyHeaders(lastModified, request.headers(), response.headers(), this.setLastModifiedHeader());
        }
        response.headers().contentType(this.mediaType);
        if (method == Http.Method.GET) {
            FileBasedContentHandler.send(request, response, this.path);
        } else {
            FileBasedContentHandler.processContentLength(this.path, response.headers());
            response.send();
        }
        return true;
    }
}

