/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.http.BadRequestException;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

record ByteRangeRequest(long fileLength, long offset, long length) {
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\d+)?-(\\d+)?(?:, )?");

    static List<ByteRangeRequest> parse(ServerRequest req, ServerResponse res, String headerValues, long fileLength) {
        Matcher matcher = RANGE_PATTERN.matcher(headerValues);
        ArrayList<ByteRangeRequest> parts = new ArrayList<ByteRangeRequest>();
        boolean found = false;
        while (matcher.find()) {
            found = true;
            String firstGroup = matcher.group(1);
            String secondGroup = matcher.group(2);
            long from = 0L;
            long last = fileLength - 1L;
            if (firstGroup != null) {
                from = Long.parseLong(firstGroup);
            }
            if (secondGroup != null) {
                long second = Long.parseLong(secondGroup);
                if (firstGroup == null) {
                    from = fileLength - second;
                    last = fileLength - 1L;
                } else {
                    last = second;
                }
            }
            parts.add(ByteRangeRequest.create(req, res, from, last, fileLength));
        }
        if (!found) {
            throw new BadRequestException("Invalid range header");
        }
        return parts;
    }

    void setContentRange(ServerResponse response) {
        long last = this.offset + this.length - 1L;
        response.header(Http.Headers.create((Http.HeaderName)Http.HeaderNames.CONTENT_RANGE, (boolean)true, (boolean)false, (String[])new String[]{"bytes " + this.offset + "-" + last + "/" + this.fileLength}));
        response.contentLength(this.length);
        response.status(Http.Status.PARTIAL_CONTENT_206);
    }

    private static ByteRangeRequest create(ServerRequest req, ServerResponse res, long offset, long last, long fileLength) {
        if (offset >= fileLength || last < offset) {
            res.header(Http.HeaderNames.CONTENT_RANGE, new String[]{"*/" + fileLength});
            throw new HttpException("Wrong range", Http.Status.REQUESTED_RANGE_NOT_SATISFIABLE_416, true);
        }
        long length = last - offset + 1L;
        return new ByteRangeRequest(fileLength, offset, length);
    }
}

