/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.sse;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Status;
import io.helidon.http.sse.SseEvent;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.http.spi.Sink;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.BiConsumer;

public class SseSink
implements Sink<SseEvent> {
    public static final GenericType<SseSink> TYPE = GenericType.create(SseSink.class);
    private static final byte[] SSE_NL = "\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SSE_ID = "id:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SSE_DATA = "data:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SSE_EVENT = "event:".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SSE_COMMENT = ":".getBytes(StandardCharsets.UTF_8);
    private final BiConsumer<Object, MediaType> eventConsumer;
    private final Runnable closeRunnable;
    private final OutputStream outputStream;

    SseSink(ServerResponse serverResponse, BiConsumer<Object, MediaType> eventConsumer, Runnable closeRunnable) {
        HttpMediaType ct = serverResponse.headers().contentType().orElse(null);
        if (serverResponse.status().code() != Status.OK_200.code() || ct != null && !HeaderValues.CONTENT_TYPE_EVENT_STREAM.values().equals(ct.mediaType().text())) {
            throw new IllegalStateException("ServerResponse instance cannot be used to create SseResponse");
        }
        if (ct == null) {
            serverResponse.headers().add(HeaderValues.CONTENT_TYPE_EVENT_STREAM);
        }
        this.outputStream = serverResponse.outputStream();
        this.eventConsumer = eventConsumer;
        this.closeRunnable = closeRunnable;
    }

    public SseSink emit(SseEvent sseEvent) {
        try {
            Object data;
            Optional name;
            Optional id;
            Optional comment = sseEvent.comment();
            if (comment.isPresent()) {
                this.outputStream.write(SSE_COMMENT);
                this.outputStream.write(((String)comment.get()).getBytes(StandardCharsets.UTF_8));
                this.outputStream.write(SSE_NL);
            }
            if ((id = sseEvent.id()).isPresent()) {
                this.outputStream.write(SSE_ID);
                this.outputStream.write(((String)id.get()).getBytes(StandardCharsets.UTF_8));
                this.outputStream.write(SSE_NL);
            }
            if ((name = sseEvent.name()).isPresent()) {
                this.outputStream.write(SSE_EVENT);
                this.outputStream.write(((String)name.get()).getBytes(StandardCharsets.UTF_8));
                this.outputStream.write(SSE_NL);
            }
            if ((data = sseEvent.data()) != null) {
                this.outputStream.write(SSE_DATA);
                this.eventConsumer.accept(data, sseEvent.mediaType().orElse(MediaTypes.TEXT_PLAIN));
                this.outputStream.write(SSE_NL);
            }
            this.outputStream.write(SSE_NL);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public void close() {
        this.closeRunnable.run();
    }
}

