/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.servicecommon;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.servicecommon.FeatureSupport;
import io.helidon.webserver.servicecommon.RestServiceSettings;
import java.util.Objects;

public abstract class HelidonFeatureSupport
implements FeatureSupport {
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private final System.Logger logger;
    private final String configuredContext;
    private final boolean enabled;
    private String context;

    protected HelidonFeatureSupport(System.Logger logger, Builder<?, ?> builder, String serviceName) {
        this(logger, builder.restServiceSettingsBuilder.build(), serviceName);
    }

    protected HelidonFeatureSupport(System.Logger logger, RestServiceSettings restServiceSettings, String serviceName) {
        this.logger = logger;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)serviceName, (CrossOriginConfig)restServiceSettings.crossOriginConfig());
        this.configuredContext = restServiceSettings.webContext();
        this.context = (restServiceSettings.webContext().startsWith("/") ? "" : "/") + restServiceSettings.webContext();
        this.enabled = restServiceSettings.enabled();
    }

    @Override
    public final void setup(HttpRouting.Builder defaultRouting, HttpRouting.Builder featureRouting) {
        defaultRouting.any(new Handler[]{this.corsEnabledServiceHelper.processor()});
        if (defaultRouting != featureRouting) {
            featureRouting.any(new Handler[]{this.corsEnabledServiceHelper.processor()});
        }
        this.service().ifPresent(it -> featureRouting.register(this.context(), new HttpService[]{it}));
        this.postSetup(defaultRouting, featureRouting);
    }

    @Override
    public String context() {
        return this.context;
    }

    @Override
    public String configuredContext() {
        return this.configuredContext;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    protected void context(String context) {
        this.context = context;
    }

    protected void postSetup(HttpRouting.Builder defaultRouting, HttpRouting.Builder featureRouting) {
    }

    protected System.Logger logger() {
        return this.logger;
    }

    @Configured
    public static abstract class Builder<B extends Builder<B, T>, T extends HelidonFeatureSupport>
    implements io.helidon.common.Builder<B, T> {
        private Config config = Config.empty();
        private RestServiceSettings.Builder restServiceSettingsBuilder = RestServiceSettings.builder();

        protected Builder(String defaultContext) {
            this.restServiceSettingsBuilder.webContext(defaultContext);
        }

        public B config(Config config) {
            this.config = config;
            this.webContextConfig(config).asString().ifPresent(this::webContext);
            config.get("routing").asString().ifPresent(this.restServiceSettingsBuilder::routing);
            config.get("cors").map(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return (B)((Builder)this.identity());
        }

        public Config config() {
            return this.config;
        }

        @ConfiguredOption
        public B webContext(String path) {
            Object context = path.startsWith("/") ? path : "/" + path;
            this.restServiceSettingsBuilder.webContext((String)context);
            return (B)((Builder)this.identity());
        }

        @ConfiguredOption
        public B crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.restServiceSettingsBuilder.crossOriginConfig(crossOriginConfig);
            return (B)((Builder)this.identity());
        }

        public B restServiceSettings(RestServiceSettings.Builder restServiceSettingsBuilder) {
            this.restServiceSettingsBuilder = restServiceSettingsBuilder;
            return (B)((Builder)this.identity());
        }

        protected Config webContextConfig(Config config) {
            return config.get("web-context");
        }
    }
}

