/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webserver.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.http.Method;

/**
 * Interface generated from definition. Please add javadoc to the definition interface.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.webserver.security.PathsConfigBlueprint")
public interface PathsConfig extends PathsConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static PathsConfig.Builder builder() {
        return new PathsConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static PathsConfig.Builder builder(PathsConfig instance) {
        return PathsConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static PathsConfig create(Config config) {
        return PathsConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static PathsConfig create() {
        return PathsConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link PathsConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends PathsConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PathsConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private final List<Method> methods = new ArrayList<>();
        private final List<String> sockets = new ArrayList<>(List.of("@default"));
        private boolean isMethodsMutated;
        private boolean isSocketsMutated;
        private Config config;
        private SecurityHandler handler;
        private String path;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(PathsConfig prototype) {
            if (!isMethodsMutated) {
                methods.clear();
            }
            addMethods(prototype.methods());
            path(prototype.path());
            if (!isSocketsMutated) {
                sockets.clear();
            }
            addSockets(prototype.sockets());
            handler(prototype.handler());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(PathsConfig.BuilderBase<?, ?> builder) {
            if (isMethodsMutated) {
                if (builder.isMethodsMutated) {
                    addMethods(builder.methods);
                }
            } else {
                methods.clear();
                addMethods(builder.methods);
            }
            builder.path().ifPresent(this::path);
            if (isSocketsMutated) {
                if (builder.isSocketsMutated) {
                    addSockets(builder.sockets);
                }
            } else {
                sockets.clear();
                addSockets(builder.sockets);
            }
            builder.handler().ifPresent(this::handler);
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("methods").mapList(io.helidon.webserver.security.PathsConfigBlueprint::createMethods).ifPresent(this::methods);
            config.get("path").as(String.class).ifPresent(this::path);
            config.get("sockets").asList(String.class).ifPresent(this::sockets);
            config.map(SecurityHandlerConfig::create).ifPresent(this::handler);
            return self();
        }

        /**
         *
         *
         * @param methods
         * @return updated builder instance
         * @see #methods()
         */
        public BUILDER methods(List<? extends Method> methods) {
            Objects.requireNonNull(methods);
            isMethodsMutated = true;
            this.methods.clear();
            this.methods.addAll(methods);
            return self();
        }

        /**
         *
         *
         * @param methods
         * @return updated builder instance
         * @see #methods()
         */
        public BUILDER addMethods(List<? extends Method> methods) {
            Objects.requireNonNull(methods);
            isMethodsMutated = true;
            this.methods.addAll(methods);
            return self();
        }

        /**
         *
         *
         * @param method
         * @return updated builder instance
         * @see #methods()
         */
        public BUILDER addMethod(Method method) {
            Objects.requireNonNull(method);
            this.methods.add(method);
            isMethodsMutated = true;
            return self();
        }

        /**
         *
         *
         * @param path
         * @return updated builder instance
         * @see #path()
         */
        public BUILDER path(String path) {
            Objects.requireNonNull(path);
            this.path = path;
            return self();
        }

        /**
         *
         *
         * @param sockets
         * @return updated builder instance
         * @see #sockets()
         */
        public BUILDER sockets(List<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            isSocketsMutated = true;
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return self();
        }

        /**
         *
         *
         * @param sockets
         * @return updated builder instance
         * @see #sockets()
         */
        public BUILDER addSockets(List<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            isSocketsMutated = true;
            this.sockets.addAll(sockets);
            return self();
        }

        /**
         *
         *
         * @param handler
         * @return updated builder instance
         * @see #handler()
         */
        public BUILDER handler(SecurityHandler handler) {
            Objects.requireNonNull(handler);
            this.handler = handler;
            return self();
        }

        /**
         *
         *
         * @param handlerConfig
         * @return updated builder instance
         * @see #handler()
         */
        public BUILDER handler(SecurityHandlerConfig handlerConfig) {
            Objects.requireNonNull(handlerConfig);
            this.handler = SecurityHandler.create(handlerConfig);
            return self();
        }

        /**
         *
         *
         * @param consumer consumer of builder for
         * @return updated builder instance
         * @see #handler()
         */
        public BUILDER handler(Consumer<SecurityHandlerConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = SecurityHandler.builder();
            consumer.accept(builder);
            this.handler(builder.build());
            return self();
        }

        /**
         *
         *
         * @param supplier supplier of
         * @return updated builder instance
         * @see #handler()
         */
        public BUILDER handler(Supplier<? extends SecurityHandler> supplier) {
            Objects.requireNonNull(supplier);
            this.handler(supplier.get());
            return self();
        }

        /**
         *
         *
         * @return the methods
         */
        public List<Method> methods() {
            return methods;
        }

        /**
         *
         *
         * @return the path
         */
        public Optional<String> path() {
            return Optional.ofNullable(path);
        }

        /**
         *
         *
         * @return the sockets
         */
        public List<String> sockets() {
            return sockets;
        }

        /**
         *
         *
         * @return the handler
         */
        public Optional<SecurityHandler> handler() {
            return Optional.ofNullable(handler);
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "PathsConfigBuilder{"
                    + "methods=" + methods + ","
                    + "path=" + path + ","
                    + "sockets=" + sockets + ","
                    + "handler=" + handler
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (path == null) {
                collector.fatal(getClass(), "Property \"path\" must not be null, but not set");
            }
            if (handler == null) {
                collector.fatal(getClass(), "Property \"handler\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class PathsConfigImpl implements PathsConfig {

            private final List<Method> methods;
            private final List<String> sockets;
            private final SecurityHandler handler;
            private final String path;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected PathsConfigImpl(PathsConfig.BuilderBase<?, ?> builder) {
                this.methods = List.copyOf(builder.methods());
                this.path = builder.path().get();
                this.sockets = List.copyOf(builder.sockets());
                this.handler = builder.handler().get();
            }

            @Override
            public List<Method> methods() {
                return methods;
            }

            @Override
            public String path() {
                return path;
            }

            @Override
            public List<String> sockets() {
                return sockets;
            }

            @Override
            public SecurityHandler handler() {
                return handler;
            }

            @Override
            public String toString() {
                return "PathsConfig{"
                        + "methods=" + methods + ","
                        + "path=" + path + ","
                        + "sockets=" + sockets + ","
                        + "handler=" + handler
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PathsConfig other)) {
                    return false;
                }
                return Objects.equals(methods, other.methods())
                    && Objects.equals(path, other.path())
                    && Objects.equals(sockets, other.sockets())
                    && Objects.equals(handler, other.handler());
            }

            @Override
            public int hashCode() {
                return Objects.hash(methods, path, sockets, handler);
            }

        }

    }

    /**
     * Fluent API builder for {@link PathsConfig}.
     */
    class Builder extends PathsConfig.BuilderBase<PathsConfig.Builder, PathsConfig> implements io.helidon.common.Builder<PathsConfig.Builder, PathsConfig> {

        private Builder() {
        }

        @Override
        public PathsConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new PathsConfigImpl(this);
        }

        @Override
        public PathsConfig build() {
            return buildPrototype();
        }

    }

}
