/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.common.Weighted;
import io.helidon.common.config.Config;
import io.helidon.http.ForbiddenException;
import io.helidon.http.Method;
import io.helidon.http.PathMatchers;
import io.helidon.http.UnauthorizedException;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.security.PathsConfig;
import io.helidon.webserver.security.SecurityContextFilter;
import io.helidon.webserver.security.SecurityFeature;
import io.helidon.webserver.security.SecurityFeatureConfig;
import io.helidon.webserver.security.SecurityHandler;
import io.helidon.webserver.security.SecurityHandlerConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;

public final class SecurityHttpFeature
implements HttpSecurity,
HttpFeature,
Weighted {
    public static final String CONTEXT_ADD_HEADERS = "security.addHeaders";
    private static final Logger LOGGER = Logger.getLogger(SecurityHttpFeature.class.getName());
    private final Security security;
    private final SecurityHandler defaultHandler;
    private final double weight;
    private final List<PathsConfig> configs;

    private SecurityHttpFeature(Security security, double weight, SecurityHandler defaults, List<PathsConfig> configs) {
        this.security = security;
        this.weight = weight;
        this.defaultHandler = defaults;
        this.configs = configs;
    }

    public static SecurityHttpFeature create(Security security) {
        return ((SecurityFeatureConfig.Builder)SecurityFeature.builder().security(security)).build().routingFeature();
    }

    public static SecurityHttpFeature create(Config config) {
        return ((SecurityFeatureConfig.Builder)((SecurityFeatureConfig.Builder)SecurityFeature.builder().security(Security.create((Config)config.root().get("security")))).config(config)).build().routingFeature();
    }

    static SecurityHttpFeature create(Security security, double weight, SecurityHandler defaults, List<PathsConfig> configs) {
        return new SecurityHttpFeature(security, weight, defaults, configs);
    }

    public SecurityHttpFeature securityDefaults(SecurityHandler defaultHandler) {
        Objects.requireNonNull(defaultHandler, "Default security handler must not be null");
        return new SecurityHttpFeature(this.security, this.weight, defaultHandler, this.configs);
    }

    public void setup(HttpRouting.Builder rules) {
        if (!this.security.enabled()) {
            LOGGER.info("Security is disabled. Not registering any security handlers");
            return;
        }
        rules.security((HttpSecurity)this);
        rules.addFilter((Filter)new SecurityContextFilter(this.security, this.defaultHandler));
        this.registerRouting((HttpRules)rules);
    }

    public boolean authenticate(ServerRequest request, ServerResponse response, boolean requiredHint) throws UnauthorizedException {
        if (requiredHint && !request.context().get(SecurityContext.class).map(SecurityContext::isAuthenticated).orElse(false).booleanValue()) {
            throw new UnauthorizedException("User not authenticated");
        }
        return true;
    }

    public boolean authorize(ServerRequest request, ServerResponse response, String ... roleHint) throws ForbiddenException {
        Optional maybeContext = request.context().get(SecurityContext.class);
        if (maybeContext.isEmpty()) {
            if (roleHint.length == 0) {
                return true;
            }
            throw new ForbiddenException("This endpoint is restricted");
        }
        SecurityContext ctx = (SecurityContext)maybeContext.get();
        if (roleHint.length == 0) {
            if (!ctx.isAuthorized()) {
                throw new ForbiddenException("This endpoint is restricted");
            }
            return true;
        }
        if (!ctx.isAuthorized()) {
            for (String role : roleHint) {
                if (!ctx.isUserInRole(role)) continue;
                return true;
            }
            throw new ForbiddenException("This endpoint is restricted");
        }
        return true;
    }

    public double weight() {
        return this.weight;
    }

    private void registerRouting(HttpRules routing) {
        for (PathsConfig config : this.configs) {
            SecurityHandler pathHandler = ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.defaultHandler.prototype())).from(config.handler().prototype())).build();
            if (config.methods().isEmpty()) {
                routing.any(config.path(), new Handler[]{pathHandler});
                continue;
            }
            routing.route((Predicate)Method.predicate(config.methods()), PathMatchers.create((String)config.path()), (Handler)pathHandler);
        }
    }
}

