/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.webserver.ContextualRegistry;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.netty.HttpInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyWebServer
implements WebServer {
    private static final Logger LOGGER = Logger.getLogger(NettyWebServer.class.getName());
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final Map<String, ServerBootstrap> bootstraps = new HashMap<String, ServerBootstrap>();
    private final ServerConfiguration configuration;
    private final CompletableFuture<WebServer> startFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> shutdownFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> channelsUpFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> channelsCloseFuture = new CompletableFuture();
    private final CompletableFuture<WebServer> threadGroupsShutdownFuture = new CompletableFuture();
    private final ContextualRegistry contextualRegistry = ContextualRegistry.create();
    private final ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final List<HttpInitializer> initializers = new LinkedList<HttpInitializer>();
    private volatile boolean started;
    private final AtomicBoolean shutdownThreadGroupsInitiated = new AtomicBoolean(false);

    NettyWebServer(ServerConfiguration config, Routing routing, Map<String, Routing> namedRoutings) {
        Set sockets = config.sockets().entrySet();
        this.bossGroup = new NioEventLoopGroup(sockets.size());
        this.workerGroup = config.workersCount() <= 0 ? new NioEventLoopGroup() : new NioEventLoopGroup(config.workersCount());
        this.configuration = config;
        for (Map.Entry entry : sockets) {
            String name = (String)entry.getKey();
            SocketConfiguration soConfig = (SocketConfiguration)entry.getValue();
            ServerBootstrap bootstrap = new ServerBootstrap();
            JdkSslContext sslContext = null;
            if (soConfig.ssl() != null) {
                sslContext = new JdkSslContext(soConfig.ssl(), false, ClientAuth.NONE);
            }
            if (soConfig.backlog() > 0) {
                bootstrap.option(ChannelOption.SO_BACKLOG, (Object)soConfig.backlog());
            }
            if (soConfig.timeoutMillis() > 0) {
                bootstrap.option(ChannelOption.SO_TIMEOUT, (Object)soConfig.backlog());
            }
            if (soConfig.receiveBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)soConfig.receiveBufferSize());
            }
            HttpInitializer childHandler = new HttpInitializer((SslContext)sslContext, namedRoutings.getOrDefault(name, routing), this);
            this.initializers.add(childHandler);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)childHandler);
            this.bootstraps.put(name, bootstrap);
        }
    }

    public ServerConfiguration configuration() {
        return this.configuration;
    }

    public synchronized CompletionStage<WebServer> start() {
        if (!this.started) {
            ((CompletableFuture)this.channelsUpFuture.thenAccept(this.startFuture::complete)).exceptionally(throwable -> {
                if (this.channels.isEmpty()) {
                    this.startFailureHandler((Throwable)throwable);
                }
                for (Channel channel : this.channels.values()) {
                    channel.close();
                }
                return null;
            });
            this.channelsCloseFuture.whenComplete((webServer, throwable) -> this.shutdown((Throwable)throwable));
            Set<Map.Entry<String, ServerBootstrap>> bootstrapEntries = this.bootstraps.entrySet();
            int bootstrapsSize = bootstrapEntries.size();
            for (Map.Entry<String, ServerBootstrap> entry : bootstrapEntries) {
                int port;
                ServerBootstrap bootstrap = entry.getValue();
                String name = entry.getKey();
                SocketConfiguration socketConfig = this.configuration.socket(name);
                if (socketConfig == null) {
                    throw new IllegalStateException("no socket configuration found for name: " + name);
                }
                int n = port = socketConfig.port() <= 0 ? 0 : socketConfig.port();
                if (this.channelsUpFuture.isCompletedExceptionally()) break;
                try {
                    bootstrap.bind(this.configuration.bindAddress(), port).addListener(channelFuture -> {
                        if (!channelFuture.isSuccess()) {
                            LOGGER.info(() -> "Channel '" + name + "' startup failed. Startup failure routine initiated.");
                            this.channelsUpFuture.completeExceptionally(new IllegalStateException("Channel startup failed: " + name, channelFuture.cause()));
                            return;
                        }
                        Channel channel = ((ChannelFuture)channelFuture).channel();
                        LOGGER.info(() -> "Channel '" + name + "' started: " + channel);
                        this.channels.put(name, channel);
                        channel.closeFuture().addListener(future -> {
                            LOGGER.info(() -> "Channel '" + name + "' closed: " + channel);
                            this.channels.remove(name);
                            if (this.channelsUpFuture.isCompletedExceptionally()) {
                                if (this.channels.isEmpty()) {
                                    this.channelsUpFuture.exceptionally(this::startFailureHandler);
                                } else if (future.cause() != null) {
                                    LOGGER.log(Level.WARNING, "Startup failure channel close failure", new IllegalStateException(future.cause()));
                                }
                            } else if (!future.isSuccess()) {
                                this.channelsCloseFuture.completeExceptionally(new IllegalStateException("Channel stop failure.", future.cause()));
                            } else if (this.channels.isEmpty()) {
                                this.channelsCloseFuture.complete(this);
                            }
                        });
                        if (this.channelsUpFuture.isCompletedExceptionally()) {
                            channel.close();
                        }
                        if (this.channels.size() >= bootstrapsSize) {
                            LOGGER.finer(() -> "All channels started: " + this.channels.size());
                            this.channelsUpFuture.complete(this);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    if (this.shutdownThreadGroupsInitiated.get()) break;
                    throw e;
                }
            }
            this.started = true;
            LOGGER.fine(() -> "All channels startup routine initiated: " + bootstrapsSize);
        }
        return this.startFuture;
    }

    private WebServer startFailureHandler(Throwable throwable) {
        this.shutdownThreadGroups().whenComplete((webServer, t) -> {
            if (t != null) {
                LOGGER.log(Level.WARNING, "Netty Thread Groups were unable to shutdown.", (Throwable)t);
            }
            this.startFuture.completeExceptionally(new IllegalStateException("WebServer was unable to start.", throwable));
            this.shutdownFuture.complete(this);
        });
        return null;
    }

    private void shutdown(Throwable cause) {
        this.shutdownThreadGroups().whenComplete((webServer, throwable) -> {
            if (cause == null && throwable == null) {
                this.shutdownFuture.complete(this);
            } else if (cause != null) {
                if (throwable != null) {
                    LOGGER.log(Level.WARNING, "Netty Thread Groups were unable to shutdown.", (Throwable)throwable);
                }
                this.shutdownFuture.completeExceptionally(new IllegalStateException("WebServer was unable to stop.", cause));
            } else {
                this.shutdownFuture.completeExceptionally(new IllegalStateException("WebServer was unable to stop.", (Throwable)throwable));
            }
        });
    }

    private CompletionStage<WebServer> shutdownThreadGroups() {
        if (this.shutdownThreadGroupsInitiated.getAndSet(true)) {
            return this.threadGroupsShutdownFuture;
        }
        this.forceQueuesRelease();
        Future bossGroupFuture = this.bossGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        Future workerGroupFuture = this.workerGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        workerGroupFuture.addListener(workerFuture -> bossGroupFuture.addListener(bossFuture -> {
            if (workerFuture.isSuccess() && bossFuture.isSuccess()) {
                this.threadGroupsShutdownFuture.complete(this);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(workerFuture.cause() != null ? "Worker Group problem: " + workerFuture.cause().getMessage() : "").append(bossFuture.cause() != null ? "Boss Group problem: " + bossFuture.cause().getMessage() : "");
                this.threadGroupsShutdownFuture.completeExceptionally(new IllegalStateException("Unable to shutdown Netty thread groups: " + sb));
            }
        }));
        return this.threadGroupsShutdownFuture;
    }

    private void forceQueuesRelease() {
        this.initializers.removeIf(httpInitializer -> {
            httpInitializer.queuesShutdown();
            return true;
        });
    }

    public CompletionStage<WebServer> shutdown() {
        if (!this.startFuture.isDone()) {
            this.startFuture.cancel(true);
        }
        if (this.channels.isEmpty()) {
            this.channelsCloseFuture.complete(this);
        }
        for (Channel channel : this.channels.values()) {
            channel.close();
        }
        return this.shutdownFuture;
    }

    public CompletionStage<WebServer> whenShutdown() {
        return this.shutdownFuture;
    }

    public boolean isRunning() {
        return this.startFuture.isDone() && !this.shutdownFuture.isDone();
    }

    public ContextualRegistry context() {
        return this.contextualRegistry;
    }

    public int port(String name) {
        Channel channel = (Channel)this.channels.get(name);
        if (channel == null) {
            return -1;
        }
        SocketAddress address = channel.localAddress();
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getPort() : -1;
    }
}

