/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.webserver.Routing;
import io.helidon.webserver.netty.ByteBufRequestChunk;
import io.helidon.webserver.netty.ForwardingHandler;
import io.helidon.webserver.netty.NettyWebServer;
import io.helidon.webserver.netty.ReferenceHoldingQueue;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLEngine;

class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslContext;
    private final NettyWebServer webServer;
    private final Routing routing;
    private final Queue<ReferenceHoldingQueue<ByteBufRequestChunk>> queues = new ConcurrentLinkedQueue<ReferenceHoldingQueue<ByteBufRequestChunk>>();

    HttpInitializer(SslContext sslContext, Routing routing, NettyWebServer webServer) {
        this.routing = routing;
        this.sslContext = sslContext;
        this.webServer = webServer;
    }

    private void clearQueues() {
        this.queues.removeIf(ReferenceHoldingQueue::release);
    }

    void queuesShutdown() {
        this.queues.removeIf(queue -> {
            queue.shutdown();
            return true;
        });
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        SSLEngine sslEngine = null;
        if (this.sslContext != null) {
            SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            p.addLast(new ChannelHandler[]{sslHandler});
        }
        p.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        p.addLast(new ChannelHandler[]{new ForwardingHandler(this.routing, this.webServer, sslEngine, this.queues)});
        ch.eventLoop().execute(this::clearQueues);
    }
}

