/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.common.reactive.Flow;
import io.helidon.webserver.Http;
import io.helidon.webserver.RequestChunk;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.spi.BareRequest;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;

class BareRequestImpl
implements BareRequest {
    private final HttpRequest nettyRequest;
    private final Flow.Publisher<RequestChunk> publisher;
    private final WebServer webServer;
    private final ChannelHandlerContext ctx;
    private final SSLEngine sslEngine;
    private final long requestId;

    BareRequestImpl(HttpRequest request, Flow.Publisher<RequestChunk> publisher, WebServer webServer, ChannelHandlerContext ctx, SSLEngine sslEngine, long requestId) {
        this.nettyRequest = request;
        this.publisher = publisher;
        this.webServer = webServer;
        this.ctx = ctx;
        this.sslEngine = sslEngine;
        this.requestId = requestId;
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public Http.RequestMethod getMethod() {
        return Http.RequestMethod.from((String)this.nettyRequest.method().name());
    }

    public Http.Version getVersion() {
        return Http.Version.of((String)this.nettyRequest.protocolVersion().text());
    }

    public URI getUri() {
        return URI.create(this.nettyRequest.uri());
    }

    public String getLocalAddress() {
        return this.hostString(this.ctx.channel().localAddress());
    }

    public int getLocalPort() {
        return this.port(this.ctx.channel().localAddress());
    }

    public String getRemoteAddress() {
        return this.hostString(this.ctx.channel().remoteAddress());
    }

    public int getRemotePort() {
        return this.port(this.ctx.channel().remoteAddress());
    }

    private String hostString(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : null;
    }

    private int port(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getPort() : -1;
    }

    public boolean isSecure() {
        return this.sslEngine != null;
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : this.nettyRequest.headers().entries()) {
            map.computeIfAbsent((String)entry.getKey(), s -> new ArrayList()).add((String)entry.getValue());
        }
        return map;
    }

    public Flow.Publisher<RequestChunk> bodyPublisher() {
        return this.publisher;
    }

    public long requestId() {
        return this.requestId;
    }
}

