/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.Http2Configuration;
import io.helidon.webserver.Routing;
import io.helidon.webserver.netty.ByteBufRequestChunk;
import io.helidon.webserver.netty.ForwardingHandler;
import io.helidon.webserver.netty.HelidonConnectionHandler;
import io.helidon.webserver.netty.NettyWebServer;
import io.helidon.webserver.netty.ReferenceHoldingQueue;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = Logger.getLogger(HttpInitializer.class.getName());
    private final SslContext sslContext;
    private final NettyWebServer webServer;
    private final Routing routing;
    private final Queue<ReferenceHoldingQueue<ByteBufRequestChunk>> queues = new ConcurrentLinkedQueue<ReferenceHoldingQueue<ByteBufRequestChunk>>();

    HttpInitializer(SslContext sslContext, Routing routing, NettyWebServer webServer) {
        this.routing = routing;
        this.sslContext = sslContext;
        this.webServer = webServer;
    }

    private void clearQueues() {
        this.queues.removeIf(ReferenceHoldingQueue::release);
    }

    void queuesShutdown() {
        this.queues.removeIf(queue -> {
            queue.shutdown();
            return true;
        });
    }

    public void initChannel(SocketChannel ch) {
        ExperimentalConfiguration experimental;
        ChannelPipeline p = ch.pipeline();
        SSLEngine sslEngine = null;
        if (this.sslContext != null) {
            SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            p.addLast(new ChannelHandler[]{sslHandler});
        }
        if ((experimental = this.webServer.configuration().experimental()) != null && experimental.http2() != null && experimental.http2().enable()) {
            Http2Configuration http2Config = experimental.http2();
            HttpServerCodec sourceCodec = new HttpServerCodec();
            HelidonConnectionHandler helidonHandler = new HelidonConnectionHandler.HelidonHttp2ConnectionHandlerBuilder().maxContentLength(http2Config.maxContentLength()).build();
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, protocol -> AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol) ? new Http2ServerUpgradeCodec((Http2ConnectionHandler)helidonHandler) : null);
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)helidonHandler);
            p.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
            p.addLast(new ChannelHandler[]{new HelidonEventLogger()});
        } else {
            p.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
            p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        }
        p.addLast(new ChannelHandler[]{new ForwardingHandler(this.routing, this.webServer, sslEngine, this.queues)});
        ch.eventLoop().execute(this::clearQueues);
    }

    private static final class HelidonEventLogger
    extends ChannelInboundHandlerAdapter {
        private HelidonEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            LOGGER.info("Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }
}

