/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ConnectionClosedException;
import io.helidon.webserver.SocketClosedException;
import io.helidon.webserver.spi.BareResponse;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class BareResponseImpl
implements BareResponse {
    private static final Logger LOGGER = Logger.getLogger(BareResponseImpl.class.getName());
    private final boolean keepAlive;
    private final ChannelHandlerContext ctx;
    private final AtomicBoolean statusHeadersSent = new AtomicBoolean(false);
    private final AtomicBoolean internallyClosed = new AtomicBoolean(false);
    private final CompletableFuture<BareResponse> responseFuture;
    private final CompletableFuture<BareResponse> headersFuture;
    private final BooleanSupplier requestContentConsumed;
    private final Thread thread;
    private final long requestId;
    private volatile Flow.Subscription subscription;

    BareResponseImpl(ChannelHandlerContext ctx, HttpRequest request, BooleanSupplier requestContentConsumed, Thread thread, long requestId) {
        this.requestContentConsumed = requestContentConsumed;
        this.thread = thread;
        this.responseFuture = new CompletableFuture();
        this.headersFuture = new CompletableFuture();
        ((CompletableFuture)this.responseFuture.thenRun(() -> this.headersFuture.complete(this))).exceptionally(thr -> {
            this.headersFuture.completeExceptionally((Throwable)thr);
            return null;
        });
        this.ctx = ctx;
        this.requestId = requestId;
        ctx.channel().closeFuture().addListener(channelFuture -> this.responseFuture.completeExceptionally((Throwable)new SocketClosedException("Response channel is closed!")));
        this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
    }

    public void writeStatusAndHeaders(Http.ResponseStatus status, Map<String, List<String>> headers) {
        Objects.requireNonNull(status, "Parameter 'statusCode' was null!");
        if (!this.statusHeadersSent.compareAndSet(false, true)) {
            throw new IllegalStateException("Status and headers were already sent");
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status.code()));
        for (Map.Entry<String, List<String>> headerEntry : headers.entrySet()) {
            response.headers().add(headerEntry.getKey(), (Iterable)headerEntry.getValue());
        }
        if (this.keepAlive) {
            if (status.code() != Http.Status.NO_CONTENT_204.code()) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
            }
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.runOnOutboundEventLoopThread(() -> {
            this.ctx.writeAndFlush((Object)response).addListener(future -> {
                if (future.isSuccess()) {
                    this.headersFuture.complete(this);
                }
            }).addListener(this.completeOnFailureListener("An exception occurred when writing headers.")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            LOGGER.finest(() -> this.log("Writing headers: " + status));
        });
        this.headersFuture.complete(this);
    }

    private void completeResponseFuture(Throwable throwable) {
        if (throwable == null) {
            this.responseFuture.complete(this);
        } else {
            LOGGER.log(Level.FINER, throwable, () -> this.log("Response completion failed!"));
            this.responseFuture.completeExceptionally(throwable);
        }
    }

    private void completeInternal(Throwable throwable) {
        if (!this.internallyClosed.compareAndSet(false, true)) {
            this.completeResponseFuture(throwable);
            return;
        }
        if (this.keepAlive) {
            this.runOnOutboundEventLoopThread(() -> {
                LOGGER.finest(() -> this.log("Writing an empty last http content; keep-alive: true"));
                if (!this.requestContentConsumed.getAsBoolean()) {
                    LOGGER.finer(() -> this.log("Request content not fully read; trying to keep the connection; keep-alive: true"));
                    this.ctx.channel().read();
                }
                this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER)).addListener(this.completeOnFailureListener("An exception occurred when writing last http content.")).addListener(this.preventMaskingExceptionOnFailureListener(throwable)).addListener(this.completeOnSuccessListener(throwable)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            });
        } else {
            this.runOnOutboundEventLoopThread(() -> {
                LOGGER.finest(() -> this.log("Closing with an empty buffer; keep-alive: " + this.keepAlive));
                this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER)).addListener(this.completeOnFailureListener("An exception occurred when writing last http content.")).addListener(this.preventMaskingExceptionOnFailureListener(throwable)).addListener(this.completeOnSuccessListener(throwable)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            });
        }
    }

    private GenericFutureListener<Future<? super Void>> completeOnFailureListener(String message) {
        return future -> {
            if (!future.isSuccess()) {
                this.completeResponseFuture(new IllegalStateException(message, future.cause()));
            }
        };
    }

    private GenericFutureListener<Future<? super Void>> preventMaskingExceptionOnFailureListener(Throwable throwable) {
        return future -> {
            if (!future.isSuccess() && throwable != null) {
                LOGGER.log(Level.FINE, throwable, () -> this.log("Response completion failed when handling an error."));
            }
        };
    }

    private GenericFutureListener<Future<? super Void>> completeOnSuccessListener(Throwable throwable) {
        return future -> {
            if (future.isSuccess()) {
                this.completeResponseFuture(throwable);
                LOGGER.finest(() -> this.log("Last http message flushed."));
            }
        };
    }

    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(DataChunk data) {
        if (this.internallyClosed.get()) {
            throw new IllegalStateException("Response is already closed!");
        }
        if (data != null) {
            LOGGER.finest(() -> this.log("Sending data chunk"));
            DefaultHttpContent httpContent = new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)data.data()));
            this.runOnOutboundEventLoopThread(() -> {
                LOGGER.finest(() -> this.log("Sending data chunk on event loop thread."));
                ChannelFuture channelFuture = data.flush() ? this.ctx.writeAndFlush((Object)httpContent) : this.ctx.write((Object)httpContent);
                channelFuture.addListener(future -> {
                    data.release();
                    LOGGER.finest(() -> this.log("Data chunk sent with result: " + future.isSuccess()));
                }).addListener(this.completeOnFailureListener("Failure when sending a content!")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            });
        }
    }

    private String log(String s) {
        return "(reqID: " + this.requestId + ") " + s;
    }

    private void runOnOutboundEventLoopThread(Runnable runnable) {
        block5: {
            if (Thread.currentThread() != this.thread) {
                ChannelHandlerContext context = this.ctx.pipeline().context(ChannelOutboundHandler.class);
                if (context == null) {
                    throw new ConnectionClosedException("The connection was closed.");
                }
                EventExecutor executor = context.executor();
                CountDownLatch latch = new CountDownLatch(1);
                executor.execute(() -> {
                    if (Thread.currentThread() != this.thread) {
                        throw new IllegalStateException(String.format("Assertion error! Current thread '%s' != expected one '%s'", Thread.currentThread(), this.thread));
                    }
                    latch.countDown();
                    runnable.run();
                });
                try {
                    if (!latch.await(30L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("Timed out while waiting for a message to be written on the event loop.");
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while waiting for the task to be executed on an event loop thread", e);
                }
            }
            runnable.run();
        }
    }

    public void onError(Throwable thr) {
        this.completeInternal(thr);
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void onComplete() {
        this.completeInternal(null);
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public CompletionStage<BareResponse> whenCompleted() {
        return this.responseFuture;
    }

    public CompletionStage<BareResponse> whenHeadersCompleted() {
        return this.headersFuture;
    }

    public long requestId() {
        return this.requestId;
    }
}

