/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.common.http.DataChunk;
import io.helidon.webserver.netty.ReferenceHoldingQueue;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class ByteBufRequestChunk
implements DataChunk {
    private static final Logger LOGGER = Logger.getLogger(ByteBufRequestChunk.class.getName());
    private static final AtomicLong ID_INCREMENTER = new AtomicLong(1L);
    private final long id = ID_INCREMENTER.getAndIncrement();
    private final ByteBuffer byteBuffer;
    private final ReferenceHoldingQueue.ReleasableReference<ByteBufRequestChunk> ref;

    ByteBufRequestChunk(ByteBuf byteBuf, ReferenceHoldingQueue<ByteBufRequestChunk> referenceHoldingQueue) {
        Objects.requireNonNull(byteBuf, "The ByteBuf must not be null!");
        this.byteBuffer = byteBuf.nioBuffer().asReadOnlyBuffer();
        this.ref = new ReferenceHoldingQueue.ReleasableReference<ByteBufRequestChunk>(this, referenceHoldingQueue, () -> ((ByteBuf)byteBuf).release());
        byteBuf.retain();
    }

    public boolean isReleased() {
        return this.ref.isReleased();
    }

    public ByteBuffer data() {
        if (this.isReleased()) {
            throw new IllegalStateException("The request chunk was already released!");
        }
        return this.byteBuffer;
    }

    public void release() {
        this.ref.release();
    }

    public long id() {
        return this.id;
    }

    protected void finalize() {
        if (!this.isReleased()) {
            OneTimeLoggerHolder.logOnce();
            this.release();
        }
    }

    static class OneTimeLoggerHolder {
        OneTimeLoggerHolder() {
        }

        static void logOnce() {
        }

        static {
            LOGGER.warning("LEAK: RequestChunk.release() was not called before it was garbage collected. While the Reactive WebServer is designed to automatically release all the RequestChunks, it still comes with a considerable performance penalty and a demand for a large memory space (depending on expected throughput, it might require even more than 2GB). As such the users are strongly advised to release all the RequestChunk instances explicitly when they're not needed.");
        }
    }
}

