/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Header;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.RoutedPath;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.ProxyProtocolData;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http2.Http2ServerRequestEntity;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

class Http2ServerRequest
implements RoutingRequest {
    private static final RequestedUriDiscoveryContext DEFAULT_REQUESTED_URI_DISCOVERY_CONTEXT = RequestedUriDiscoveryContext.builder().build();
    private static final Runnable NO_OP_RUNNABLE = () -> {};
    private final Http2Headers http2Headers;
    private final ServerRequestHeaders headers;
    private final ConnectionContext ctx;
    private final HttpPrologue originalPrologue;
    private final int requestId;
    private final String authority;
    private final LazyValue<Http2ServerRequestEntity> entity;
    private final HttpSecurity security;
    private final LazyValue<UriInfo> uriInfo = LazyValue.create(this::createUriInfo);
    private HttpPrologue prologue;
    private RoutedPath path;
    private WritableHeaders<?> writable;
    private Context context;
    private boolean continueSent;
    private UnaryOperator<InputStream> streamFilter = UnaryOperator.identity();

    Http2ServerRequest(ConnectionContext ctx, HttpSecurity security, HttpPrologue prologue, Http2Headers headers, ContentDecoder decoder, int requestId, Supplier<BufferData> entitySupplier) {
        this.ctx = ctx;
        this.security = security;
        this.originalPrologue = prologue;
        this.http2Headers = headers;
        this.headers = ServerRequestHeaders.create((Headers)headers.httpHeaders());
        this.requestId = requestId;
        this.authority = headers.authority();
        this.entity = LazyValue.create(() -> Http2ServerRequestEntity.create(this.streamFilter, (UnaryOperator<InputStream>)decoder, arg_0 -> Http2ServerRequest.lambda$new$1((Supplier)entitySupplier, arg_0), NO_OP_RUNNABLE, this.headers, ctx.listenerContext().mediaContext()));
    }

    static Http2ServerRequest create(ConnectionContext ctx, HttpSecurity security, HttpPrologue httpPrologue, Http2Headers headers, ContentDecoder decoder, int streamId, Supplier<BufferData> entitySupplier) {
        return new Http2ServerRequest(ctx, security, httpPrologue, headers, decoder, streamId, entitySupplier);
    }

    public void reset() {
    }

    public boolean isSecure() {
        return this.ctx.isSecure();
    }

    public RoutedPath path() {
        return this.path;
    }

    public ReadableEntity content() {
        return (ReadableEntity)this.entity.get();
    }

    public String socketId() {
        return this.ctx.childSocketId();
    }

    public String serverSocketId() {
        return this.ctx.socketId();
    }

    public HttpPrologue prologue() {
        return this.prologue == null ? this.originalPrologue : this.prologue;
    }

    public ServerRequestHeaders headers() {
        return this.headers;
    }

    public UriQuery query() {
        return this.prologue().query();
    }

    public PeerInfo remotePeer() {
        return this.ctx.remotePeer();
    }

    public PeerInfo localPeer() {
        return this.ctx.localPeer();
    }

    public String authority() {
        return this.authority;
    }

    public void header(Header header) {
        if (this.writable == null) {
            this.writable = WritableHeaders.create((Headers)this.headers);
        }
        this.writable.set(header);
    }

    public int id() {
        return this.requestId;
    }

    public Http2ServerRequest path(RoutedPath routedPath) {
        this.path = routedPath;
        return this;
    }

    public RoutingRequest prologue(HttpPrologue newPrologue) {
        this.prologue = newPrologue;
        return this;
    }

    public ListenerContext listenerContext() {
        return this.ctx.listenerContext();
    }

    public Context context() {
        if (this.context == null) {
            this.context = Contexts.context().orElseGet(() -> Context.builder().parent(this.ctx.listenerContext().context()).id("[" + this.serverSocketId() + " " + this.socketId() + "] http/1.1: " + this.requestId).build());
        }
        return this.context;
    }

    public HttpSecurity security() {
        return this.security;
    }

    public UriInfo requestedUri() {
        return (UriInfo)this.uriInfo.get();
    }

    public boolean continueSent() {
        return this.continueSent;
    }

    public void streamFilter(UnaryOperator<InputStream> filterFunction) {
        Objects.requireNonNull(filterFunction);
        UnaryOperator<InputStream> current = this.streamFilter;
        this.streamFilter = it -> (InputStream)filterFunction.apply((InputStream)current.apply((InputStream)it));
    }

    public Optional<ProxyProtocolData> proxyProtocolData() {
        return this.ctx.proxyProtocolData();
    }

    private UriInfo createUriInfo() {
        return this.ctx.listenerContext().config().requestedUriDiscoveryContext().orElse(DEFAULT_REQUESTED_URI_DISCOVERY_CONTEXT).uriInfo(this.remotePeer().address().toString(), this.localPeer().address().toString(), this.path.path(), this.headers, this.query(), this.isSecure());
    }

    private static /* synthetic */ BufferData lambda$new$1(Supplier entitySupplier, Integer it) {
        return (BufferData)entitySupplier.get();
    }
}

