/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.spi.ProtocolConfig;
import java.time.Duration;

@Prototype.Blueprint(decorator=Http2ConfigDecorator.class)
@Prototype.Configured
@Prototype.Provides(value={ProtocolConfig.class})
interface Http2ConfigBlueprint
extends ProtocolConfig {
    @Option.Configured
    @Option.DefaultInt(value={16384})
    public int maxFrameSize();

    @Option.Configured
    @Option.DefaultInt(value={8192})
    public long maxHeaderListSize();

    @Option.Configured
    @Option.DefaultLong(value={8192L})
    public long maxConcurrentStreams();

    @Option.Configured
    @Option.DefaultInt(value={0x100000})
    public int initialWindowSize();

    @Option.Configured
    @Option.Default(value={"PT0.1S"})
    public Duration flowControlTimeout();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean sendErrorDetails();

    @Option.Configured
    @Option.Default(value={"PT10S"})
    public Duration rapidResetCheckPeriod();

    @Option.Configured
    @Option.DefaultInt(value={100})
    public int maxRapidResets();

    @Option.Configured
    @Option.DefaultInt(value={10})
    public int maxEmptyFrames();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean validatePath();

    @Option.Configured
    public RequestedUriDiscoveryContext requestedUriDiscovery();

    default public String type() {
        return "http_2";
    }

    public static class Http2ConfigDecorator
    implements Prototype.BuilderDecorator<Http2Config.BuilderBase<?, ?>> {
        public void decorate(Http2Config.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.name("@default");
            }
            if (target.requestedUriDiscovery().isEmpty()) {
                target.requestedUriDiscovery(RequestedUriDiscoveryContext.builder().socketId(target.name().orElse("@default")).build());
            }
        }
    }
}

