/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http2.Http2ConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.http2.Http2ConfigBlueprint")
public interface Http2Config
extends Http2ConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Http2Config instance) {
        return (Builder)Http2Config.builder().from(instance);
    }

    public static Http2Config create(Config config) {
        return ((Builder)Http2Config.builder().config(config)).buildPrototype();
    }

    public static Http2Config create() {
        return Http2Config.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Http2Config>
    implements io.helidon.common.Builder<Builder, Http2Config> {
        private Builder() {
        }

        public Http2Config buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.Http2ConfigImpl(this);
        }

        public Http2Config build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http2Config>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean sendErrorDetails = false;
        private boolean validatePath = true;
        private Config config;
        private Duration flowControlTimeout = Duration.parse("PT0.1S");
        private Duration rapidResetCheckPeriod = Duration.parse("PT10S");
        private int initialWindowSize = 0x100000;
        private int maxEmptyFrames = 10;
        private int maxFrameSize = 16384;
        private int maxRapidResets = 100;
        private long maxConcurrentStreams = 8192L;
        private long maxHeaderListSize = 8192L;
        private RequestedUriDiscoveryContext requestedUriDiscovery;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(Http2Config prototype) {
            this.maxFrameSize(prototype.maxFrameSize());
            this.maxHeaderListSize(prototype.maxHeaderListSize());
            this.maxConcurrentStreams(prototype.maxConcurrentStreams());
            this.initialWindowSize(prototype.initialWindowSize());
            this.flowControlTimeout(prototype.flowControlTimeout());
            this.sendErrorDetails(prototype.sendErrorDetails());
            this.rapidResetCheckPeriod(prototype.rapidResetCheckPeriod());
            this.maxRapidResets(prototype.maxRapidResets());
            this.maxEmptyFrames(prototype.maxEmptyFrames());
            this.validatePath(prototype.validatePath());
            this.requestedUriDiscovery(prototype.requestedUriDiscovery());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.maxFrameSize(builder.maxFrameSize());
            this.maxHeaderListSize(builder.maxHeaderListSize());
            this.maxConcurrentStreams(builder.maxConcurrentStreams());
            this.initialWindowSize(builder.initialWindowSize());
            this.flowControlTimeout(builder.flowControlTimeout());
            this.sendErrorDetails(builder.sendErrorDetails());
            this.rapidResetCheckPeriod(builder.rapidResetCheckPeriod());
            this.maxRapidResets(builder.maxRapidResets());
            this.maxEmptyFrames(builder.maxEmptyFrames());
            this.validatePath(builder.validatePath());
            builder.requestedUriDiscovery().ifPresent(this::requestedUriDiscovery);
            builder.name().ifPresent(this::name);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("max-frame-size").as(Integer.class).ifPresent(this::maxFrameSize);
            config.get("max-header-list-size").as(Long.class).ifPresent(this::maxHeaderListSize);
            config.get("max-concurrent-streams").as(Long.class).ifPresent(this::maxConcurrentStreams);
            config.get("initial-window-size").as(Integer.class).ifPresent(this::initialWindowSize);
            config.get("flow-control-timeout").as(Duration.class).ifPresent(this::flowControlTimeout);
            config.get("send-error-details").as(Boolean.class).ifPresent(this::sendErrorDetails);
            config.get("rapid-reset-check-period").as(Duration.class).ifPresent(this::rapidResetCheckPeriod);
            config.get("max-rapid-resets").as(Integer.class).ifPresent(this::maxRapidResets);
            config.get("max-empty-frames").as(Integer.class).ifPresent(this::maxEmptyFrames);
            config.get("validate-path").as(Boolean.class).ifPresent(this::validatePath);
            config.get("requested-uri-discovery").map(RequestedUriDiscoveryContext::create).ifPresent(this::requestedUriDiscovery);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxFrameSize(int maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxHeaderListSize(long maxHeaderListSize) {
            this.maxHeaderListSize = maxHeaderListSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxConcurrentStreams(long maxConcurrentStreams) {
            this.maxConcurrentStreams = maxConcurrentStreams;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initialWindowSize(int initialWindowSize) {
            this.initialWindowSize = initialWindowSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER flowControlTimeout(Duration flowControlTimeout) {
            Objects.requireNonNull(flowControlTimeout);
            this.flowControlTimeout = flowControlTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sendErrorDetails(boolean sendErrorDetails) {
            this.sendErrorDetails = sendErrorDetails;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rapidResetCheckPeriod(Duration rapidResetCheckPeriod) {
            Objects.requireNonNull(rapidResetCheckPeriod);
            this.rapidResetCheckPeriod = rapidResetCheckPeriod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxRapidResets(int maxRapidResets) {
            this.maxRapidResets = maxRapidResets;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxEmptyFrames(int maxEmptyFrames) {
            this.maxEmptyFrames = maxEmptyFrames;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER validatePath(boolean validatePath) {
            this.validatePath = validatePath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(RequestedUriDiscoveryContext requestedUriDiscovery) {
            Objects.requireNonNull(requestedUriDiscovery);
            this.requestedUriDiscovery = requestedUriDiscovery;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(Consumer<RequestedUriDiscoveryContext.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RequestedUriDiscoveryContext.Builder builder = RequestedUriDiscoveryContext.builder();
            consumer.accept(builder);
            this.requestedUriDiscovery(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscovery(Supplier<? extends RequestedUriDiscoveryContext> supplier) {
            Objects.requireNonNull(supplier);
            this.requestedUriDiscovery(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int maxFrameSize() {
            return this.maxFrameSize;
        }

        public long maxHeaderListSize() {
            return this.maxHeaderListSize;
        }

        public long maxConcurrentStreams() {
            return this.maxConcurrentStreams;
        }

        public int initialWindowSize() {
            return this.initialWindowSize;
        }

        public Duration flowControlTimeout() {
            return this.flowControlTimeout;
        }

        public boolean sendErrorDetails() {
            return this.sendErrorDetails;
        }

        public Duration rapidResetCheckPeriod() {
            return this.rapidResetCheckPeriod;
        }

        public int maxRapidResets() {
            return this.maxRapidResets;
        }

        public int maxEmptyFrames() {
            return this.maxEmptyFrames;
        }

        public boolean validatePath() {
            return this.validatePath;
        }

        public Optional<RequestedUriDiscoveryContext> requestedUriDiscovery() {
            return Optional.ofNullable(this.requestedUriDiscovery);
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "Http2ConfigBuilder{maxFrameSize=" + this.maxFrameSize + ",maxHeaderListSize=" + this.maxHeaderListSize + ",maxConcurrentStreams=" + this.maxConcurrentStreams + ",initialWindowSize=" + this.initialWindowSize + ",flowControlTimeout=" + String.valueOf(this.flowControlTimeout) + ",sendErrorDetails=" + this.sendErrorDetails + ",rapidResetCheckPeriod=" + String.valueOf(this.rapidResetCheckPeriod) + ",maxRapidResets=" + this.maxRapidResets + ",maxEmptyFrames=" + this.maxEmptyFrames + ",validatePath=" + this.validatePath + ",requestedUriDiscovery=" + String.valueOf(this.requestedUriDiscovery) + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
            new Http2ConfigBlueprint.Http2ConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.requestedUriDiscovery == null) {
                collector.fatal(this.getClass(), "Property \"requested-uri-discovery\" must not be null, but not set");
            }
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class Http2ConfigImpl
        implements Http2Config {
            private final boolean sendErrorDetails;
            private final boolean validatePath;
            private final Duration flowControlTimeout;
            private final Duration rapidResetCheckPeriod;
            private final int initialWindowSize;
            private final int maxEmptyFrames;
            private final int maxFrameSize;
            private final int maxRapidResets;
            private final long maxConcurrentStreams;
            private final long maxHeaderListSize;
            private final RequestedUriDiscoveryContext requestedUriDiscovery;
            private final String name;

            protected Http2ConfigImpl(BuilderBase<?, ?> builder) {
                this.maxFrameSize = builder.maxFrameSize();
                this.maxHeaderListSize = builder.maxHeaderListSize();
                this.maxConcurrentStreams = builder.maxConcurrentStreams();
                this.initialWindowSize = builder.initialWindowSize();
                this.flowControlTimeout = builder.flowControlTimeout();
                this.sendErrorDetails = builder.sendErrorDetails();
                this.rapidResetCheckPeriod = builder.rapidResetCheckPeriod();
                this.maxRapidResets = builder.maxRapidResets();
                this.maxEmptyFrames = builder.maxEmptyFrames();
                this.validatePath = builder.validatePath();
                this.requestedUriDiscovery = builder.requestedUriDiscovery().get();
                this.name = builder.name().get();
            }

            @Override
            public int maxFrameSize() {
                return this.maxFrameSize;
            }

            @Override
            public long maxHeaderListSize() {
                return this.maxHeaderListSize;
            }

            @Override
            public long maxConcurrentStreams() {
                return this.maxConcurrentStreams;
            }

            @Override
            public int initialWindowSize() {
                return this.initialWindowSize;
            }

            @Override
            public Duration flowControlTimeout() {
                return this.flowControlTimeout;
            }

            @Override
            public boolean sendErrorDetails() {
                return this.sendErrorDetails;
            }

            @Override
            public Duration rapidResetCheckPeriod() {
                return this.rapidResetCheckPeriod;
            }

            @Override
            public int maxRapidResets() {
                return this.maxRapidResets;
            }

            @Override
            public int maxEmptyFrames() {
                return this.maxEmptyFrames;
            }

            @Override
            public boolean validatePath() {
                return this.validatePath;
            }

            @Override
            public RequestedUriDiscoveryContext requestedUriDiscovery() {
                return this.requestedUriDiscovery;
            }

            public String name() {
                return this.name;
            }

            public String toString() {
                return "Http2Config{maxFrameSize=" + this.maxFrameSize + ",maxHeaderListSize=" + this.maxHeaderListSize + ",maxConcurrentStreams=" + this.maxConcurrentStreams + ",initialWindowSize=" + this.initialWindowSize + ",flowControlTimeout=" + String.valueOf(this.flowControlTimeout) + ",sendErrorDetails=" + this.sendErrorDetails + ",rapidResetCheckPeriod=" + String.valueOf(this.rapidResetCheckPeriod) + ",maxRapidResets=" + this.maxRapidResets + ",maxEmptyFrames=" + this.maxEmptyFrames + ",validatePath=" + this.validatePath + ",requestedUriDiscovery=" + String.valueOf(this.requestedUriDiscovery) + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http2Config)) {
                    return false;
                }
                Http2Config other = (Http2Config)o;
                return this.maxFrameSize == other.maxFrameSize() && this.maxHeaderListSize == other.maxHeaderListSize() && this.maxConcurrentStreams == other.maxConcurrentStreams() && this.initialWindowSize == other.initialWindowSize() && Objects.equals(this.flowControlTimeout, other.flowControlTimeout()) && this.sendErrorDetails == other.sendErrorDetails() && Objects.equals(this.rapidResetCheckPeriod, other.rapidResetCheckPeriod()) && this.maxRapidResets == other.maxRapidResets() && this.maxEmptyFrames == other.maxEmptyFrames() && this.validatePath == other.validatePath() && Objects.equals(this.requestedUriDiscovery, other.requestedUriDiscovery()) && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.maxFrameSize, this.maxHeaderListSize, this.maxConcurrentStreams, this.initialWindowSize, this.flowControlTimeout, this.sendErrorDetails, this.rapidResetCheckPeriod, this.maxRapidResets, this.maxEmptyFrames, this.validatePath, this.requestedUriDiscovery, this.name);
            }
        }
    }
}

