/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.SocketWriterException;
import io.helidon.http.DirectHandler;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RequestException;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.http2.ConnectionFlowControl;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Priority;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2Stream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2ServerRequest;
import io.helidon.webserver.http2.Http2ServerResponse;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.http2.spi.SubProtocolResult;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;

public class Http2ServerStream
implements Runnable,
Http2Stream {
    private static final DataFrame TERMINATING_FRAME = new DataFrame(Http2FrameHeader.create((int)0, (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)1), (int)0), BufferData.empty());
    private static final System.Logger LOGGER = System.getLogger(Http2Stream.class.getName());
    private static final Set<Http2StreamState> DATA_RECEIVABLE_STATES = Set.of(Http2StreamState.OPEN, Http2StreamState.HALF_CLOSED_LOCAL);
    private final ConnectionContext ctx;
    private final Http2Config http2Config;
    private final List<Http2SubProtocolSelector> subProviders;
    private final int streamId;
    private final Http2Settings serverSettings;
    private final Http2Settings clientSettings;
    private final Http2StreamWriter writer;
    private final Router router;
    private final ArrayBlockingQueue<DataFrame> inboundData = new ArrayBlockingQueue(32);
    private final StreamFlowControl flowControl;
    private boolean wasLastDataFrame = false;
    private volatile Http2Headers headers;
    private volatile Http2Priority priority;
    private volatile Http2StreamState state = Http2StreamState.IDLE;
    private WriteState writeState = WriteState.INIT;
    private Http2SubProtocolSelector.SubProtocolHandler subProtocolHandler;
    private long expectedLength = -1L;
    private HttpRouting routing;
    private HttpPrologue prologue;
    private volatile Semaphore requestSemaphore = new Semaphore(1);
    private boolean semaphoreAcquired;

    public Http2ServerStream(ConnectionContext ctx, HttpRouting routing, Http2Config http2Config, List<Http2SubProtocolSelector> subProviders, int streamId, Http2Settings serverSettings, Http2Settings clientSettings, Http2StreamWriter writer, ConnectionFlowControl connectionFlowControl) {
        this.ctx = ctx;
        this.routing = routing;
        this.http2Config = http2Config;
        this.subProviders = subProviders;
        this.streamId = streamId;
        this.serverSettings = serverSettings;
        this.clientSettings = clientSettings;
        this.writer = writer;
        this.router = ctx.router();
        this.flowControl = connectionFlowControl.createStreamFlowControl(streamId, http2Config.initialWindowSize(), http2Config.maxFrameSize());
    }

    public void checkNotClosed() throws Http2Exception {
        if (this.state == Http2StreamState.HALF_CLOSED_REMOTE || this.state == Http2StreamState.CLOSED) {
            throw new Http2Exception(Http2ErrorCode.STREAM_CLOSED, "Stream " + this.streamId + " is closed. State: " + String.valueOf(this.state));
        }
    }

    public void checkDataReceivable() throws Http2Exception {
        if (!DATA_RECEIVABLE_STATES.contains(this.state)) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received data for stream " + this.streamId + " in state " + String.valueOf(this.state));
        }
    }

    public void checkHeadersReceivable() throws Http2Exception {
        switch (this.state) {
            case IDLE: {
                break;
            }
            case HALF_CLOSED_LOCAL: 
            case HALF_CLOSED_REMOTE: 
            case CLOSED: {
                throw new Http2Exception(Http2ErrorCode.STREAM_CLOSED, "Stream " + this.streamId + " received headers when stream is " + String.valueOf(this.state));
            }
            case OPEN: {
                throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received headers for open stream " + this.streamId);
            }
            default: {
                throw new Http2Exception(Http2ErrorCode.INTERNAL, "Unknown stream state: " + this.streamId + ", state: " + String.valueOf(this.state));
            }
        }
    }

    public void rstStream(Http2RstStream rstStream) {
        if (this.state == Http2StreamState.IDLE) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received RST_STREAM for stream " + this.streamId + " in IDLE state");
        }
        this.state = Http2StreamState.CLOSED;
    }

    public void windowUpdate(Http2WindowUpdate windowUpdate) {
        Http2RstStream frame;
        if (this.state == Http2StreamState.IDLE) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received WINDOW_UPDATE for stream " + this.streamId + " in state IDLE");
        }
        if (windowUpdate.windowSizeIncrement() == 0) {
            frame = new Http2RstStream(Http2ErrorCode.PROTOCOL);
            this.writer.write(frame.toFrameData(this.clientSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        if (this.flowControl.outbound().incrementStreamWindowSize(windowUpdate.windowSizeIncrement()) > Integer.MAX_VALUE) {
            frame = new Http2RstStream(Http2ErrorCode.FLOW_CONTROL);
            this.writer.write(frame.toFrameData(this.clientSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
    }

    public void headers(Http2Headers headers, boolean endOfStream) {
        this.headers = headers;
        Http2StreamState http2StreamState = this.state = endOfStream ? Http2StreamState.HALF_CLOSED_REMOTE : Http2StreamState.OPEN;
        if (this.state == Http2StreamState.HALF_CLOSED_REMOTE) {
            try {
                this.inboundData.put(TERMINATING_FRAME);
            }
            catch (InterruptedException e) {
                throw new Http2Exception(Http2ErrorCode.INTERNAL, "Interrupted", (Throwable)e);
            }
        }
    }

    public void data(Http2FrameHeader header, BufferData data, boolean endOfStream) {
        if (this.expectedLength != -1L && this.expectedLength < (long)header.length()) {
            this.state = Http2StreamState.CLOSED;
            Http2RstStream rst = new Http2RstStream(Http2ErrorCode.PROTOCOL);
            this.writer.write(rst.toFrameData(this.clientSettings, this.streamId, Http2Flag.NoFlags.create()));
            return;
        }
        if (this.expectedLength != -1L) {
            this.expectedLength -= (long)header.length();
        }
        try {
            this.inboundData.put(new DataFrame(header, data));
        }
        catch (InterruptedException e) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Interrupted", (Throwable)e);
        }
    }

    public void priority(Http2Priority http2Priority) {
        int i = http2Priority.streamId();
        if (i == this.streamId) {
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Stream depends on itself");
        }
        this.priority = http2Priority;
    }

    public int streamId() {
        return this.streamId;
    }

    public Http2StreamState streamState() {
        return this.state;
    }

    public StreamFlowControl flowControl() {
        return this.flowControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("[" + this.ctx.socketId() + " " + this.ctx.childSocketId() + " ] - " + this.streamId);
        try {
            this.handle();
        }
        catch (SocketWriterException | CloseConnectionException | UncheckedIOException e) {
            Http2RstStream rst = new Http2RstStream(Http2ErrorCode.STREAM_CLOSED);
            this.writer.write(rst.toFrameData(this.serverSettings, this.streamId, Http2Flag.NoFlags.create()));
        }
        catch (RequestException e) {
            DirectHandler handler = this.ctx.listenerContext().directHandlers().handler(e.eventType());
            DirectHandler.TransportResponse response = handler.handle(e.request(), e.eventType(), e.status(), e.responseHeaders(), (Throwable)e);
            ServerResponseHeaders headers = response.headers();
            byte[] message = response.entity().orElse(BufferData.EMPTY_BYTES);
            if (message.length != 0) {
                headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (String)String.valueOf(message.length)));
            }
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)headers);
            if (message.length == 0) {
                this.writer.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)5), this.flowControl.outbound());
            } else {
                Http2FrameHeader dataHeader = Http2FrameHeader.create((int)message.length, (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)1), (int)this.streamId);
                this.writer.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)4), new Http2FrameData(dataHeader, BufferData.create((byte[])message)), this.flowControl.outbound());
            }
        }
        finally {
            this.headers = null;
            this.subProtocolHandler = null;
            if (this.semaphoreAcquired) {
                this.requestSemaphore.release();
            }
        }
    }

    int writeHeaders(Http2Headers http2Headers, boolean endOfStream) {
        this.writeState = this.writeState.check(endOfStream ? WriteState.END : WriteState.HEADERS_SENT);
        Http2Flag.HeaderFlags flags = endOfStream ? Http2Flag.HeaderFlags.create((int)5) : Http2Flag.HeaderFlags.create((int)4);
        return this.writer.writeHeaders(http2Headers, this.streamId, flags, this.flowControl.outbound());
    }

    int writeHeadersWithData(Http2Headers http2Headers, int contentLength, BufferData bufferData, boolean endOfStream) {
        this.writeState = this.writeState.check(WriteState.HEADERS_SENT);
        this.writeState = this.writeState.check(endOfStream ? WriteState.END : WriteState.DATA_SENT);
        Http2FrameData frameData = new Http2FrameData(Http2FrameHeader.create((int)contentLength, (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)(endOfStream ? 1 : 0)), (int)this.streamId), bufferData);
        return this.writer.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)4), frameData, this.flowControl.outbound());
    }

    int writeData(BufferData bufferData, boolean endOfStream) {
        this.writeState = this.writeState.check(endOfStream ? WriteState.END : WriteState.DATA_SENT);
        Http2FrameData frameData = new Http2FrameData(Http2FrameHeader.create((int)bufferData.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)(endOfStream ? 1 : 0)), (int)this.streamId), bufferData);
        this.writer.writeData(frameData, this.flowControl.outbound());
        return frameData.header().length() + 9;
    }

    int writeTrailers(Http2Headers http2trailers) {
        this.writeState = this.writeState.check(WriteState.TRAILERS_SENT);
        return this.writer.writeHeaders(http2trailers, this.streamId, Http2Flag.HeaderFlags.create((int)5), this.flowControl.outbound());
    }

    void write100Continue() {
        if (this.writeState == WriteState.EXPECTED_100) {
            this.writeState = this.writeState.check(WriteState.CONTINUE_100_SENT);
            Header status = HeaderValues.createCached((HeaderName)Http2Headers.STATUS_NAME, (int)100);
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)WritableHeaders.create().add(status));
            this.writer.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)4), this.flowControl.outbound());
        }
    }

    void requestSemaphore(Semaphore requestSemaphore) {
        this.requestSemaphore = requestSemaphore;
    }

    void prologue(HttpPrologue prologue) {
        this.prologue = prologue;
    }

    ConnectionContext connectionContext() {
        return this.ctx;
    }

    private BufferData readEntityFromPipeline() {
        DataFrame frame;
        this.write100Continue();
        if (this.wasLastDataFrame) {
            return BufferData.empty();
        }
        try {
            frame = this.inboundData.take();
            this.flowControl.inbound().incrementWindowSize(frame.header().length());
        }
        catch (InterruptedException e) {
            return BufferData.empty();
        }
        if (((Http2Flag.DataFlags)frame.header().flags(Http2FrameTypes.DATA)).endOfStream()) {
            this.wasLastDataFrame = true;
        }
        return frame.data();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle() {
        Headers httpHeaders = this.headers.httpHeaders();
        if (httpHeaders.contains(HeaderNames.CONTENT_LENGTH)) {
            this.expectedLength = (Long)httpHeaders.get(HeaderNames.CONTENT_LENGTH).get(Long.TYPE);
        }
        if (this.headers.httpHeaders().contains(HeaderValues.EXPECT_100)) {
            this.writeState = this.writeState.check(WriteState.EXPECTED_100);
        }
        this.subProtocolHandler = null;
        for (Http2SubProtocolSelector provider : this.subProviders) {
            SubProtocolResult subProtocolResult = provider.subProtocol(this.ctx, this.prologue, this.headers, this.writer, this.streamId, this.serverSettings, this.clientSettings, this.flowControl, this.state, this.router);
            if (!subProtocolResult.supported()) continue;
            this.subProtocolHandler = subProtocolResult.subProtocol();
            break;
        }
        if (this.subProtocolHandler == null) {
            ContentDecoder decoder;
            ContentEncodingContext contentEncodingContext = this.ctx.listenerContext().contentEncodingContext();
            if (contentEncodingContext.contentDecodingEnabled()) {
                if (httpHeaders.contains(HeaderNames.CONTENT_ENCODING)) {
                    String contentEncoding = (String)httpHeaders.get(HeaderNames.CONTENT_ENCODING).get();
                    if (!contentEncodingContext.contentDecodingSupported(contentEncoding)) throw RequestException.builder().type(DirectHandler.EventType.OTHER).status(Status.UNSUPPORTED_MEDIA_TYPE_415).message("Unsupported content encoding").build();
                    decoder = contentEncodingContext.decoder(contentEncoding);
                } else {
                    decoder = ContentDecoder.NO_OP;
                }
            } else {
                decoder = ContentDecoder.NO_OP;
            }
            Http2ServerRequest request = Http2ServerRequest.create(this.ctx, this.routing.security(), this.prologue, this.headers, decoder, this.streamId, this::readEntityFromPipeline);
            Http2ServerResponse response = new Http2ServerResponse(this, request);
            this.semaphoreAcquired = this.requestSemaphore.tryAcquire();
            try {
                if (this.semaphoreAcquired) {
                    this.routing.route(this.ctx, (RoutingRequest)request, (RoutingResponse)response);
                    return;
                }
                this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Too many concurrent requests, rejecting request.", new Object[0]);
                ((Http2ServerResponse)response.status(Status.SERVICE_UNAVAILABLE_503)).send("Too Many Concurrent Requests");
                response.commit();
                return;
            }
            finally {
                request.content().consume();
                this.state = this.state == Http2StreamState.HALF_CLOSED_REMOTE ? Http2StreamState.CLOSED : Http2StreamState.HALF_CLOSED_LOCAL;
            }
        }
        this.subProtocolHandler.init();
        while (this.subProtocolHandler.streamState() != Http2StreamState.CLOSED && this.subProtocolHandler.streamState() != Http2StreamState.HALF_CLOSED_LOCAL) {
            DataFrame frame;
            try {
                frame = this.inboundData.take();
                this.flowControl.inbound().incrementWindowSize(frame.header().length());
            }
            catch (InterruptedException e) {
                String handlerName = this.subProtocolHandler.getClass().getSimpleName();
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "%s interrupted stream %d", new Object[]{handlerName, this.streamId});
                return;
            }
            this.subProtocolHandler.data(frame.header, frame.data);
            this.state = this.subProtocolHandler.streamState();
        }
    }

    private static enum WriteState {
        END(new WriteState[0]),
        TRAILERS_SENT(END),
        DATA_SENT(TRAILERS_SENT, END),
        HEADERS_SENT(DATA_SENT, TRAILERS_SENT, END),
        CONTINUE_100_SENT(HEADERS_SENT),
        EXPECTED_100(CONTINUE_100_SENT, HEADERS_SENT),
        INIT(EXPECTED_100, HEADERS_SENT);

        private final Set<WriteState> allowedTransitions;

        private WriteState(WriteState ... allowedTransitions) {
            this.allowedTransitions = Set.of(allowedTransitions);
        }

        WriteState check(WriteState newState) {
            if (this == newState || this.allowedTransitions.contains((Object)newState)) {
                return newState;
            }
            throw new IllegalStateException("Transition from " + String.valueOf((Object)this) + " to " + String.valueOf((Object)newState) + " is not allowed!");
        }
    }

    private record DataFrame(Http2FrameHeader header, BufferData data) {
    }
}

