/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.DateTime;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.ServerResponseTrailers;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponseBase;
import io.helidon.webserver.http2.Http2ServerRequest;
import io.helidon.webserver.http2.Http2ServerStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.UnaryOperator;

class Http2ServerResponse
extends ServerResponseBase<Http2ServerResponse> {
    private static final System.Logger LOGGER = System.getLogger(Http2ServerResponse.class.getName());
    private final ConnectionContext ctx;
    private final ServerResponseHeaders headers;
    private final ServerResponseTrailers trailers;
    private final Http2ServerRequest request;
    private final Http2ServerStream stream;
    private boolean isSent;
    private boolean streamingEntity;
    private long bytesWritten;
    private BlockingOutputStream outputStream;
    private UnaryOperator<OutputStream> outputStreamFilter;
    private String streamResult = null;

    Http2ServerResponse(Http2ServerStream stream, Http2ServerRequest request) {
        super(stream.connectionContext(), (ServerRequest)request);
        this.ctx = stream.connectionContext();
        this.request = request;
        this.stream = stream;
        this.headers = ServerResponseHeaders.create();
        this.trailers = ServerResponseTrailers.create();
    }

    public Http2ServerResponse header(Header header) {
        this.headers.set(header);
        return this;
    }

    public void send(byte[] entityBytes) {
        if (this.outputStreamFilter != null) {
            try (OutputStream os = this.outputStream();){
                os.write(entityBytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return;
        }
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("When output stream is used, response is completed by closing the output stream, do not call send().");
        }
        this.isSent = true;
        byte[] bytes = this.entityBytes(entityBytes);
        this.headers.setIfAbsent(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (boolean)true, (boolean)false, (String[])new String[]{String.valueOf(bytes.length)}));
        this.headers.setIfAbsent(HeaderValues.create((HeaderName)HeaderNames.DATE, (boolean)true, (boolean)false, (String[])new String[]{DateTime.rfc1123String()}));
        Http2Headers http2Headers = Http2Headers.create((WritableHeaders)this.headers);
        http2Headers.status(this.status());
        this.headers.remove(Http2Headers.STATUS_NAME, it -> this.ctx.log(LOGGER, System.Logger.Level.WARNING, "Status must be configured on response, do not set HTTP/2 pseudo headers", new Object[0]));
        boolean sendTrailers = this.request.headers().contains(HeaderValues.TE_TRAILERS) || this.headers.contains(HeaderNames.TRAILER);
        http2Headers.validateResponse();
        this.bytesWritten += (long)this.stream.writeHeadersWithData(http2Headers, bytes.length, BufferData.create((byte[])bytes), !sendTrailers);
        if (sendTrailers) {
            this.bytesWritten += (long)this.stream.writeTrailers(Http2Headers.create((WritableHeaders)this.trailers));
        }
        this.afterSend();
    }

    public boolean isSent() {
        return this.isSent;
    }

    public OutputStream outputStream() {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        this.streamingEntity = true;
        if (this.request.headers().contains(HeaderValues.TE_TRAILERS)) {
            this.headers.add(STREAM_TRAILERS);
        }
        this.outputStream = new BlockingOutputStream(this.request, this, () -> {
            this.isSent = true;
            this.afterSend();
        });
        if (this.outputStreamFilter == null) {
            return this.contentEncode(this.outputStream);
        }
        return (OutputStream)this.outputStreamFilter.apply(this.contentEncode(this.outputStream));
    }

    public long bytesWritten() {
        return this.streamingEntity ? this.outputStream.bytesWritten : this.bytesWritten;
    }

    public ServerResponseHeaders headers() {
        return this.headers;
    }

    public ServerResponseTrailers trailers() {
        if (this.request.headers().contains(HeaderValues.TE_TRAILERS) || this.headers.contains(HeaderNames.TRAILER)) {
            return this.trailers;
        }
        throw new IllegalStateException("Trailers are supported only when request came with 'TE: trailers' header or response headers have trailer names definition 'Trailer: <trailer-name>'");
    }

    public void streamResult(String result) {
        this.streamResult = result;
    }

    public boolean hasEntity() {
        return this.isSent || this.streamingEntity;
    }

    public boolean reset() {
        if (this.isSent || this.outputStream != null && this.outputStream.bytesWritten > 0L) {
            return false;
        }
        this.headers.clear();
        this.streamingEntity = false;
        this.outputStream = null;
        return true;
    }

    public void commit() {
        if (this.outputStream != null) {
            this.outputStream.commit();
        }
    }

    public void streamFilter(UnaryOperator<OutputStream> filterFunction) {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        Objects.requireNonNull(filterFunction);
        UnaryOperator<OutputStream> current = this.outputStreamFilter;
        this.outputStreamFilter = current == null ? filterFunction : it -> (OutputStream)filterFunction.apply((OutputStream)current.apply((OutputStream)it));
    }

    private static class BlockingOutputStream
    extends OutputStream {
        private final Http2ServerRequest request;
        private final ServerResponseHeaders headers;
        private final ServerResponseTrailers trailers;
        private final Status status;
        private final Runnable responseCloseRunnable;
        private final Http2ServerResponse response;
        private final Http2ServerStream stream;
        private BufferData firstBuffer;
        private boolean closed;
        private boolean firstByte = true;
        private long bytesWritten;

        private BlockingOutputStream(Http2ServerRequest request, Http2ServerResponse response, Runnable responseCloseRunnable) {
            this.request = request;
            this.response = response;
            this.headers = response.headers;
            this.trailers = response.trailers;
            this.stream = response.stream;
            this.status = response.status();
            this.responseCloseRunnable = responseCloseRunnable;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(BufferData.create((int)1).write(b));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(BufferData.create((byte[])b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(BufferData.create((byte[])b, (int)off, (int)len));
        }

        @Override
        public void flush() throws IOException {
            if (this.firstByte && this.firstBuffer != null) {
                this.write(BufferData.empty());
            }
        }

        @Override
        public void close() {
        }

        void commit() {
            boolean sendTrailers;
            if (this.closed) {
                return;
            }
            this.closed = true;
            boolean bl = sendTrailers = this.request.headers().contains(HeaderValues.TE_TRAILERS) || this.headers.contains(HeaderNames.TRAILER);
            if (this.firstByte) {
                this.sendFirstChunkOnly(sendTrailers);
            } else if (sendTrailers) {
                this.sendTrailers();
            } else {
                this.bytesWritten += (long)this.stream.writeData(BufferData.empty(), true);
            }
            this.responseCloseRunnable.run();
            try {
                super.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void write(BufferData buffer) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            if (this.firstByte && this.firstBuffer == null) {
                this.firstBuffer = buffer.copy();
                return;
            }
            if (this.firstByte) {
                this.sendHeadersAndPrepare();
                this.firstByte = false;
                this.bytesWritten += (long)this.stream.writeData(BufferData.create((BufferData[])new BufferData[]{this.firstBuffer, buffer}), false);
            } else {
                this.bytesWritten += (long)this.stream.writeData(buffer, false);
            }
        }

        private void sendFirstChunkOnly(boolean sendTrailers) {
            int contentLength;
            if (this.firstBuffer == null) {
                this.headers.set(HeaderValues.CONTENT_LENGTH_ZERO);
                contentLength = 0;
            } else {
                this.headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (boolean)true, (boolean)false, (String[])new String[]{String.valueOf(this.firstBuffer.available())}));
                contentLength = this.firstBuffer.available();
            }
            this.headers.setIfAbsent(HeaderValues.create((HeaderName)HeaderNames.DATE, (boolean)true, (boolean)false, (String[])new String[]{DateTime.rfc1123String()}));
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)this.headers);
            http2Headers.status(this.status);
            http2Headers.validateResponse();
            this.bytesWritten = contentLength == 0 ? (this.bytesWritten += (long)this.stream.writeHeaders(http2Headers, !sendTrailers)) : (this.bytesWritten += (long)this.stream.writeHeadersWithData(http2Headers, contentLength, this.firstBuffer, !sendTrailers));
        }

        private void sendHeadersAndPrepare() {
            this.headers.setIfAbsent(HeaderValues.create((HeaderName)HeaderNames.DATE, (boolean)true, (boolean)false, (String[])new String[]{DateTime.rfc1123String()}));
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)this.headers);
            http2Headers.status(this.status);
            http2Headers.validateResponse();
            this.bytesWritten += (long)this.stream.writeHeaders(http2Headers, false);
        }

        private void sendTrailers() {
            if (this.response.streamResult != null) {
                this.trailers.set(STREAM_RESULT_NAME, new String[]{this.response.streamResult});
            }
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)this.trailers);
            this.bytesWritten += (long)this.stream.writeTrailers(http2Headers);
        }
    }
}

