/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.builder.api.Prototype;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.spi.ProtocolConfig;
import java.time.Duration;

@Prototype.Blueprint(decorator=Http2ConfigDecorator.class)
@Configured(provides={ProtocolConfig.class})
interface Http2ConfigBlueprint
extends ProtocolConfig {
    @ConfiguredOption(value="16384")
    public int maxFrameSize();

    @ConfiguredOption(value="8192")
    public long maxHeaderListSize();

    @ConfiguredOption(value="8192")
    public long maxConcurrentStreams();

    @ConfiguredOption(value="1048576")
    public int initialWindowSize();

    @ConfiguredOption(value="PT0.1S")
    public Duration flowControlTimeout();

    @ConfiguredOption(value="false")
    public boolean sendErrorDetails();

    @ConfiguredOption(value="true")
    public boolean validatePath();

    @ConfiguredOption
    public RequestedUriDiscoveryContext requestedUriDiscovery();

    default public String type() {
        return "http_2";
    }

    public static class Http2ConfigDecorator
    implements Prototype.BuilderDecorator<Http2Config.BuilderBase<?, ?>> {
        public void decorate(Http2Config.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.name("@default");
            }
            if (target.requestedUriDiscovery().isEmpty()) {
                target.requestedUriDiscovery(RequestedUriDiscoveryContext.builder().socketId(target.name().orElse("@default")).build());
            }
        }
    }
}

