/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.webserver.http2.InboundHttp2ToHttpAdapterWrapper;
import io.helidon.webserver.http2.ResetStreamChannelAdapter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.logging.LogLevel;

class HelidonConnectionHandler
extends HttpToHttp2ConnectionHandler
implements Http2FrameListener {
    private final InboundHttp2ToHttpAdapter inboundAdapter;

    HelidonConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, int maxContentLength) {
        super(decoder, encoder, initialSettings, true);
        this.inboundAdapter = InboundHttp2ToHttpAdapterWrapper.create(decoder.connection(), maxContentLength, true, true);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addLast(new ChannelHandler[]{new ResetStreamChannelAdapter()});
        super.handlerAdded(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)evt;
            FullHttpRequest request = upgradeEvent.upgradeRequest();
            Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).path((CharSequence)request.uri()).scheme((CharSequence)HttpScheme.HTTP.name());
            String host = request.headers().get((CharSequence)HttpHeaderNames.HOST);
            if (host != null) {
                headers.authority((CharSequence)host);
            }
            this.onHeadersRead(ctx, 1, headers, 0, true);
        }
        super.userEventTriggered(ctx, evt);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        return this.inboundAdapter.onDataRead(ctx, streamId, data, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        this.inboundAdapter.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.inboundAdapter.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        this.inboundAdapter.onRstStreamRead(ctx, streamId, errorCode);
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        this.inboundAdapter.onPushPromiseRead(ctx, streamId, promisedStreamId, headers, padding);
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        this.inboundAdapter.onSettingsRead(ctx, settings);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
        this.inboundAdapter.onPriorityRead(ctx, streamId, streamDependency, weight, exclusive);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
        this.inboundAdapter.onSettingsAckRead(ctx);
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        this.inboundAdapter.onPingRead(ctx, data);
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
        this.inboundAdapter.onPingAckRead(ctx, data);
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        this.inboundAdapter.onGoAwayRead(ctx, lastStreamId, errorCode, debugData);
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
        this.inboundAdapter.onWindowUpdateRead(ctx, streamId, windowSizeIncrement);
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
        this.inboundAdapter.onUnknownFrame(ctx, frameType, streamId, flags, payload);
    }

    static final class HelidonHttp2ConnectionHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<HelidonConnectionHandler, HelidonHttp2ConnectionHandlerBuilder> {
        private static final Http2FrameLogger LOGGER = new Http2FrameLogger(LogLevel.DEBUG, HelidonConnectionHandler.class);
        private int maxContentLength;

        HelidonHttp2ConnectionHandlerBuilder() {
            this.frameLogger(LOGGER);
        }

        public HelidonHttp2ConnectionHandlerBuilder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        public HelidonConnectionHandler build() {
            return (HelidonConnectionHandler)super.build();
        }

        protected HelidonConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            HelidonConnectionHandler handler = new HelidonConnectionHandler(decoder, encoder, initialSettings, this.maxContentLength);
            this.frameListener(handler);
            return handler;
        }
    }
}

