/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;

class SafeStreamObserver<T>
implements StreamObserver<T> {
    private static final System.Logger LOGGER = System.getLogger(SafeStreamObserver.class.getName());
    private StreamObserver<? super T> delegate;
    private boolean done;

    private SafeStreamObserver(StreamObserver<? super T> streamObserver) {
        this.delegate = streamObserver;
    }

    public static <T> StreamObserver<T> ensureSafeObserver(StreamObserver<T> observer) {
        if (observer instanceof SafeStreamObserver) {
            return observer;
        }
        return new SafeStreamObserver<T>(observer);
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("onNext called with null. Null values are generally not allowed.").asRuntimeException());
        } else {
            try {
                this.delegate.onNext(t);
            }
            catch (Throwable thrown) {
                SafeStreamObserver.throwIfFatal(thrown);
                this.onError(thrown);
            }
        }
    }

    public void onError(Throwable thrown) {
        try {
            if (this.done) {
                LOGGER.log(System.Logger.Level.ERROR, "OnError called after StreamObserver was closed", this.checkNotNull(thrown));
            } else {
                this.done = true;
                this.delegate.onError(this.checkNotNull(thrown));
            }
        }
        catch (Throwable t) {
            SafeStreamObserver.throwIfFatal(t);
            LOGGER.log(System.Logger.Level.ERROR, "Caught exception handling onError", t);
        }
    }

    public void onCompleted() {
        if (this.done) {
            LOGGER.log(System.Logger.Level.WARNING, "onComplete called after StreamObserver was closed");
        } else {
            try {
                this.done = true;
                this.delegate.onCompleted();
            }
            catch (Throwable thrown) {
                SafeStreamObserver.throwIfFatal(thrown);
                LOGGER.log(System.Logger.Level.ERROR, "Caught exception handling onComplete", thrown);
            }
        }
    }

    public StreamObserver<? super T> delegate() {
        return this.delegate;
    }

    private static void throwIfFatal(Throwable thrown) {
        if (thrown instanceof VirtualMachineError) {
            throw (VirtualMachineError)thrown;
        }
        if (thrown instanceof ThreadDeath) {
            throw (ThreadDeath)thrown;
        }
        if (thrown instanceof LinkageError) {
            throw (LinkageError)thrown;
        }
    }

    private Throwable checkNotNull(Throwable thrown) {
        if (thrown == null) {
            thrown = Status.INVALID_ARGUMENT.withDescription("onError called with null Throwable. Null exceptions are generally not allowed.").asRuntimeException();
        }
        return thrown;
    }
}

