/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.webserver.grpc.GrpcStatus;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;

class GrpcProtocolHandlerNotFound
implements Http2SubProtocolSelector.SubProtocolHandler {
    private final Http2StreamWriter streamWriter;
    private final int streamId;
    private Http2StreamState currentStreamState;

    GrpcProtocolHandlerNotFound(Http2StreamWriter streamWriter, int streamId, Http2StreamState currentStreamState) {
        this.streamWriter = streamWriter;
        this.streamId = streamId;
        this.currentStreamState = currentStreamState;
    }

    public void init() {
        WritableHeaders writable = WritableHeaders.create();
        writable.set(GrpcStatus.NOT_FOUND);
        Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
        this.streamWriter.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)5), FlowControl.Outbound.NOOP);
        this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
    }

    public Http2StreamState streamState() {
        return this.currentStreamState;
    }

    public void rstStream(Http2RstStream rstStream) {
    }

    public void windowUpdate(Http2WindowUpdate update) {
    }

    public void data(Http2FrameHeader header, BufferData data) {
    }
}

