/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.Routing;
import io.helidon.webserver.grpc.Grpc;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcService;
import io.helidon.webserver.grpc.GrpcServiceRoute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GrpcRouting
implements Routing {
    private static final GrpcRouting EMPTY = GrpcRouting.builder().build();
    private final ArrayList<GrpcRoute> routes;

    private GrpcRouting(Builder builder) {
        this.routes = new ArrayList<GrpcRoute>(builder.routes);
    }

    public static Builder builder() {
        return new Builder();
    }

    static GrpcRouting empty() {
        return EMPTY;
    }

    public void beforeStart() {
        for (GrpcRoute route : this.routes) {
            route.beforeStart();
        }
    }

    public void afterStop() {
        for (GrpcRoute route : this.routes) {
            route.afterStop();
        }
    }

    Grpc<?, ?> findRoute(HttpPrologue prologue) {
        for (GrpcRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route.toGrpc(prologue);
        }
        return null;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GrpcRouting> {
        private final List<GrpcRoute> routes = new LinkedList<GrpcRoute>();

        private Builder() {
        }

        public GrpcRouting build() {
            return new GrpcRouting(this);
        }

        public Builder service(GrpcService service) {
            return this.route(GrpcServiceRoute.create(service));
        }

        public <ReqT, ResT> Builder unary(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            return this.route(Grpc.unary(proto, serviceName, methodName, method));
        }

        public <ReqT, ResT> Builder bidi(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            return this.route(Grpc.bidi(proto, serviceName, methodName, method));
        }

        public <ReqT, ResT> Builder serverStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            return this.route(Grpc.serverStream(proto, serviceName, methodName, method));
        }

        public <ReqT, ResT> Builder clientStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            return this.route(Grpc.clientStream(proto, serviceName, methodName, method));
        }

        public Builder service(Descriptors.FileDescriptor proto, BindableService service) {
            for (ServerMethodDefinition method : service.bindService().getMethods()) {
                this.route(Grpc.methodDefinition(method, proto));
            }
            return this;
        }

        public Builder service(ServerServiceDefinition service) {
            for (ServerMethodDefinition method : service.getMethods()) {
                this.route(Grpc.methodDefinition(method, null));
            }
            return this;
        }

        private Builder route(GrpcRoute route) {
            this.routes.add(route);
            return this;
        }
    }
}

