/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webserver.grpc.Grpc;
import io.helidon.webserver.grpc.GrpcStatus;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

class GrpcProtocolHandler<REQ, RES>
implements Http2SubProtocolSelector.SubProtocolHandler {
    private static final System.Logger LOGGER = System.getLogger(GrpcProtocolHandler.class.getName());
    private static final Header GRPC_CONTENT_TYPE = HeaderValues.createCached((HeaderName)HeaderNames.CONTENT_TYPE, (String)"application/grpc");
    private static final Header GRPC_ENCODING_IDENTITY = HeaderValues.createCached((String)"grpc-encoding", (String)"identity");
    private final HttpPrologue prologue;
    private final Http2Headers headers;
    private final Http2StreamWriter streamWriter;
    private final int streamId;
    private final Http2Settings serverSettings;
    private final Http2Settings clientSettings;
    private final Grpc<REQ, RES> route;
    private final StreamFlowControl flowControl;
    private Http2StreamState currentStreamState;
    private ServerCall.Listener<REQ> listener;
    private ServerCall<REQ, RES> serverCall;
    private long length;
    private boolean isCompressed;
    private BufferData entityBytes = null;

    GrpcProtocolHandler(HttpPrologue prologue, Http2Headers headers, Http2StreamWriter streamWriter, int streamId, Http2Settings serverSettings, Http2Settings clientSettings, StreamFlowControl flowControl, Http2StreamState currentStreamState, Grpc<REQ, RES> route) {
        this.prologue = prologue;
        this.headers = headers;
        this.streamWriter = streamWriter;
        this.streamId = streamId;
        this.serverSettings = serverSettings;
        this.clientSettings = clientSettings;
        this.flowControl = flowControl;
        this.currentStreamState = currentStreamState;
        this.route = route;
    }

    public void init() {
        try {
            this.serverCall = this.createServerCall();
            ServerCallHandler<REQ, RES> callHandler = this.route.callHandler();
            this.listener = callHandler.startCall(this.serverCall, this.toMetadata(this.headers));
            this.listener.onReady();
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to initialize grpc protocol handler", e);
            throw e;
        }
    }

    public Http2StreamState streamState() {
        return this.currentStreamState;
    }

    public void rstStream(Http2RstStream rstStream) {
        this.listener.onComplete();
    }

    public void windowUpdate(Http2WindowUpdate update) {
    }

    public void data(Http2FrameHeader header, BufferData data) {
        try {
            while (data.available() > 0) {
                if (this.entityBytes == null) {
                    this.isCompressed = data.read() == 1;
                    this.length = data.readUnsignedInt32();
                    this.entityBytes = BufferData.create((int)((int)this.length));
                }
                this.entityBytes.write(data);
                if (this.entityBytes.capacity() != 0) continue;
                byte[] bytes = new byte[this.entityBytes.available()];
                this.entityBytes.read(bytes);
                this.listener.onMessage(this.route.method().parseRequest((InputStream)new ByteArrayInputStream(bytes)));
                this.entityBytes = null;
            }
            if (((Http2Flag.DataFlags)header.flags(Http2FrameTypes.DATA)).endOfStream()) {
                this.listener.onHalfClose();
                this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
            }
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to process grpc request: " + data.debugDataHex(true), (Throwable)e);
        }
    }

    private ServerCall<REQ, RES> createServerCall() {
        return new ServerCall<REQ, RES>(){

            public void request(int numMessages) {
            }

            public void sendHeaders(Metadata headers) {
                WritableHeaders writable = WritableHeaders.create();
                writable.set(GRPC_CONTENT_TYPE);
                writable.set(GRPC_ENCODING_IDENTITY);
                Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
                http2Headers.status(Status.OK_200);
                GrpcProtocolHandler.this.streamWriter.writeHeaders(http2Headers, GrpcProtocolHandler.this.streamId, Http2Flag.HeaderFlags.create((int)4), GrpcProtocolHandler.this.flowControl.outbound());
            }

            public void sendMessage(RES message) {
                try (InputStream inputStream = GrpcProtocolHandler.this.route.method().streamResponse(message);){
                    byte[] bytes = inputStream.readAllBytes();
                    BufferData bufferData = BufferData.create((int)(5 + bytes.length));
                    bufferData.write(0);
                    bufferData.writeUnsignedInt32((long)bytes.length);
                    bufferData.write(bytes);
                    Http2FrameHeader header = Http2FrameHeader.create((int)bufferData.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)0), (int)GrpcProtocolHandler.this.streamId);
                    GrpcProtocolHandler.this.streamWriter.writeData(new Http2FrameData(header, bufferData), GrpcProtocolHandler.this.flowControl.outbound());
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed to respond to grpc request: " + String.valueOf(GrpcProtocolHandler.this.route.method()), (Throwable)e);
                }
            }

            public void close(io.grpc.Status status, Metadata trailers) {
                WritableHeaders writable = WritableHeaders.create();
                writable.set(HeaderValues.create((HeaderName)GrpcStatus.STATUS_NAME, (int)status.getCode().value()));
                String description = status.getDescription();
                if (description != null) {
                    writable.set(HeaderValues.create((HeaderName)GrpcStatus.MESSAGE_NAME, (String)description));
                }
                Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
                GrpcProtocolHandler.this.streamWriter.writeHeaders(http2Headers, GrpcProtocolHandler.this.streamId, Http2Flag.HeaderFlags.create((int)5), GrpcProtocolHandler.this.flowControl.outbound());
                GrpcProtocolHandler.this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
            }

            public boolean isCancelled() {
                return GrpcProtocolHandler.this.currentStreamState == Http2StreamState.CLOSED;
            }

            public MethodDescriptor<REQ, RES> getMethodDescriptor() {
                return GrpcProtocolHandler.this.route.method();
            }
        };
    }

    private Metadata toMetadata(Http2Headers headers) {
        return null;
    }

    private static final class BufferDataInputStream
    extends InputStream {
        private final BufferData data;

        private BufferDataInputStream(BufferData data) {
            this.data = data;
        }

        @Override
        public int read() throws IOException {
            if (this.data.available() > 0) {
                return this.data.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data.available() > 0) {
                return this.data.read(b, off, len);
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            this.data.skip(this.data.available());
        }
    }
}

