/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.grpc.GrpcConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.grpc.GrpcConfigBlueprint")
public interface GrpcConfig
extends GrpcConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcConfig instance) {
        return (Builder)GrpcConfig.builder().from(instance);
    }

    public static GrpcConfig create(Config config) {
        return ((Builder)GrpcConfig.builder().config(config)).buildPrototype();
    }

    public static GrpcConfig create() {
        return GrpcConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcConfig>
    implements io.helidon.common.Builder<Builder, GrpcConfig> {
        private Builder() {
        }

        public GrpcConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcConfigImpl(this);
        }

        public GrpcConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(GrpcConfig prototype) {
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcConfigBuilder{name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class GrpcConfigImpl
        implements GrpcConfig {
            private final String name;

            protected GrpcConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
            }

            public String name() {
                return this.name;
            }

            public String toString() {
                return "GrpcConfig{name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcConfig)) {
                    return false;
                }
                GrpcConfig other = (GrpcConfig)o;
                return Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.name);
            }
        }
    }
}

